<?php


namespace greenshiftseo\Blocks;
defined('ABSPATH') OR exit;


class Howto{

	public function __construct(){
		add_action('init', array( $this, 'init_handler' ));
	}

	public function init_handler(){
		register_block_type(__DIR__, array(
			'attributes'      => $this->attributes,
			'render_callback' => array( $this, 'render_block' ),
		));
	}

	protected $attributes = array(
		'id' => array(
			'type'    => 'string',
			'default' => null,
		),
		'inlineCssStyles' => array(
			'type'    => 'string',
			'default' => '',
		),
		'animation' => array(
			'type' => 'object',
			'default' => array(),
		),
		'borderColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'numberColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'numberBgColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'seoschema'  => array(
			'type'    => 'boolean',
			'default' => true,
		),
		'title'      => array(
			'type'    => 'string',
			'default' => 'Edit this title',
		),
		'description'      => array(
			'type'    => 'string',
			'default' => '',
		),
	);

	public function render_block($settings = array(), $content=''){

		extract($settings);
		$schemarender = ($seoschema) ? ' itemscope itemtype="https://schema.org/HowTo"' : '';
		$schemaname = ($seoschema) ? ' itemprop="name"' : '';
		$schemadescription= ($seoschema) ? ' itemprop="description"' : '';

		$borderstyle = ($borderColor) ? 'border-color:'.esc_attr($borderColor).';' : '';
		$borderbgstyle = ($borderColor) ? 'background-color:'.esc_attr($borderColor).';' : '';

		$blockId = 'gspb_id-' . esc_attr($id);
		$blockClassName = 'gspb-howto '.$blockId.' '.(!empty($className) ? $className : '').'';

		$out = '';

		$out .='<div id="'.$blockId.'" class="'.$blockClassName.'"'.gspb_AnimationRenderProps($animation).' style="'.$borderstyle.'"'.$schemarender.'>';
			$out .='<div class="gspb-howto__title">';
				$out .='<div class="gspb-howto__line" style="'.$borderbgstyle.'"></div>';
					$out .= '<div'.$schemaname.' class="gspb-howto__heading">'.wp_kses_post($title).'</div>';
				$out .='<div class="gspb-howto__line" style="'.$borderbgstyle.'"></div>';
			$out .='</div>';
			$out .='<div class="gspb-howto__description">';
				$out .= '<div'.$schemadescription.'>'.wp_kses_post($description).'</div>';
			$out .='</div>';

			$out .= $content;

		$out .='</div>';
		return $out;
	}
}

new Howto;