<?php

namespace greenshiftseo\Blocks;

defined('ABSPATH') or exit;

class OfferBox
{

	public function __construct()
	{
		add_action('init', array($this, 'init_handler'));
	}

	public function init_handler()
	{
		register_block_type(__DIR__, array(
			'attributes'      => $this->attributes,
			'render_callback' => array($this, 'render_block'),
		));
	}

	protected $attributes = array(
		'id' => array(
			'type'    => 'string',
			'default' => null,
		),
		'inlineCssStyles' => array(
			'type'    => 'string',
			'default' => '',
		),
		'animation' => array(
			'type' => 'object',
			'default' => array(),
		),
		'name' => array(
			'type'    => 'string',
			'default' => '',
		),
		'titleTag' => array(
			'type'    => 'string',
			'default' => 'h3',
		),
		'description' => array(
			'type'    => 'string',
			'default' => '',
		),
		'disclaimer'  => array(
			'type'    => 'string',
			'default' => '',
		),
		'old_price'        => array(
			'type'    => 'string',
			'default' => '',
		),
		'sale_price'       => array(
			'type'    => 'string',
			'default' => '',
		),
		'coupon_code'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'expiration_date'  => array(
			'type'    => 'string',
			'default' => '',
		),
		'offer_is_expired' => array(
			'type' => 'boolean',
			'default' => false,
		),
		'shadow' => array(
			'type' => 'boolean',
			'default' => false,
		),
		'schemaenable' => array(
			'type' => 'boolean',
			'default' => false,
		),
		'button'  => array(
			'type'    => 'object',
			'default' => array(
				'text'     => 'Buy this item',
				'url'      => '',
				'newTab' => true,
				'noFollow' => true,
				'sponsored'	=> true,
				'linkonimage' => true,
			),
		),
		'schemafields'  => array(
			'type'    => 'object',
			'default' => array(
				'mpn'     => '12345',
				'sku'     => '999GSS',
				'count'      => 5,
				'currency'   => 'USD',
				'price'   => '',
				'brand' => 'Brand',
				'valid' => '',
				'author_review' => '',
				'author_review_score' => ''
			),
		),
		'thumbnail'        => array(
			'type'    => 'object',
			'default' => array(
				'id'     => '',
				'url'    => '',
				'width'  => '',
				'height' => '',
				'imagehtml' => ''
			),
		),
		'discount_tag'     => array(
			'type'    => 'number',
			'default' => 0
		),
		'rating'           => array(
			'type'    => 'number',
			'default' => 0,
		),
		'btntColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'textColor'      => array(
			'type'    => 'string',
			'default' => '',
		),
		'buttons'   => array(
			'type'    => 'array',
			'default' => array(
				array(
				'url'=> '',
				'btntitle'=> 'Check lowest prices',
				'newTab' => true,
				'noFollow' => true,
				'sponsored'	=> true,
				'linkonimage' => true,
				'textcolor' => '#ffffff',
				'bgssolor' => '#cc0000',
				'bggradient' => '',
				'radius'=> 3
				)
				
			),
		),
		'enableMultiple' => array(
			'type' => 'boolean',
			'default' => false,
		),
	);

	public function render_block($settings = array())
	{
		extract($settings);

		$schemarender = ($schemaenable) ? ' itemtype="http://schema.org/Product" itemscope' : '';
		$schemaoffer = ($schemaenable) ? ' itemprop="offers" itemtype="http://schema.org/Offer" itemscope' : '';
		$schemarating = ($schemaenable && !empty($schemafields['count'])) ? ' itemprop="aggregateRating" itemtype="http://schema.org/AggregateRating" itemscope' : '';
		$schemaname = ($schemaenable) ? 'itemprop="name"' : '';
		$schemadescription = ($schemaenable) ? 'itemprop="description"' : '';
		$schemaurl = ($schemaenable) ? ' itemprop="url"' : '';

		$urllink = apply_filters('greenshiftseo_url_filter', $button['url']);
		$urllink = apply_filters('rh_post_offer_url_filter', $urllink);
		$urltarget = (!empty($button['newTab'])) ? ' target="_blank"' : '';
		if(!empty($button['sponsored']) || !empty($button['noFollow'])){
			$urlrel = ' rel="';
			if(!empty($button['sponsored'])){
				$urlrel .= 'sponsored';
			}
			if(!empty($button['noFollow'])){
				$urlrel .= ' nofollow';
			}
			$urlrel .= '"';
		}else{
			$urlrel = '';
		}
		$buttonimage = (!empty($button['linkonimage'])) ? true : false;
		$buttontxt = $button['text'];
		$coupon_style = $expired = '';
		if (!empty($expiration_date)) {
			$timestamp1 = strtotime($expiration_date) + 86399;
			$seconds = $timestamp1 - (int)current_time('timestamp', 0);
			$days = floor($seconds / 86400);
			$seconds %= 86400;
			if ($days > 0) {
				$coupon_text = $days . ' ' . esc_html__('days left', 'greenshiftseo');
				$coupon_style = '';
				$expired = 'no';
			} elseif ($days == 0) {
				$coupon_text = esc_html__('Last day', 'greenshiftseo');
				$coupon_style = '';
				$expired = 'no';
			} else {
				$coupon_text = esc_html__('Expired', 'greenshiftseo');
				$coupon_style = ' expired_coupon';
				$expired = '1';
			}
		}
		$imageWidthHeight = (!empty($thumbnail['width']) && !empty($thumbnail['height'])) ? ' height="' . esc_attr($thumbnail['height']) . '" width="' . esc_attr($thumbnail['width']) . '"' : '';
		$offer_thumbhtml = (!empty($thumbnail['imagehtml'])) ? $thumbnail['imagehtml'] : '';
		ob_start();

		$blockId = 'gspb_id-' . esc_attr($id);
		$blockClassName = 'gspb-offer-box '.$blockId.' '.(!empty($className) ? $className : '').'';
?>
		<div id="<?php echo esc_attr($blockId);?>" class="<?php echo esc_attr($blockClassName);?>" <?php echo gspb_AnimationRenderProps($animation);?> <?php echo '' . $schemarender; ?>>
			<?php if($rating > 0):?>
			<style scoped>#<?php echo esc_attr($blockId);?> .gspb-c-offer-box__stars{--star-color: #fdfdfd;--star-background: #fc0;--rating: <?php echo (float)$rating;?>; --percent: calc(var(--rating) / 5 * 100%);display: inline-block;font-size: 30px;font-family: Times;line-height: 1;letter-spacing: 0.5px;margin-bottom: 10px;-webkit-text-stroke-width: 0.8px; -webkit-text-stroke-color: #ffbf00;}#<?php echo esc_attr($blockId);?> .gspb-c-offer-box__stars::before {content: "★★★★★";letter-spacing: 3px;background: linear-gradient(90deg, var(--star-background) var(--percent), var(--star-color) var(--percent));-webkit-background-clip: text;-webkit-text-fill-color: transparent;}</style>
			<?php endif; ?>
			<?php if ($schemaenable) : ?>
				<meta itemprop="mpn" content="<?php echo esc_attr($schemafields['mpn']); ?>" />
				<meta itemprop="sku" content="<?php echo esc_attr($schemafields['sku']); ?>" />
				<link itemprop="image" href="<?php echo esc_url($thumbnail['url']); ?>" />
			<?php endif; ?>
			<div class="gspb-c-offer-box__wrapper">

				<div class="gspb-c-offer-box__column gspb-c-offer-box__column--image">
					<div class='gspb-c-offer-box__image'>
						<?php if ($buttonimage) : ?>
							<a href="<?php echo esc_url($urllink); ?>"<?php echo '' . $urltarget . $urlrel; ?> title="<?php echo esc_attr($name);?>">
						<?php endif; ?>
						<?php if ($offer_thumbhtml) : ?>
							<?php echo wp_kses_post($offer_thumbhtml); ?>
						<?php else : ?>
							<?php if (!empty($thumbnail['id'])) : ?>
								<?php echo wp_get_attachment_image($thumbnail['id'], 'full', false) ?>
							<?php elseif (!empty($thumbnail['url'])) : ?>
								<img src="<?php echo esc_url($thumbnail['url']); ?>" class="attachment-full size-full" alt="" loading="lazy" <?php echo '' . $imageWidthHeight; ?>>
							<?php endif; ?>
						<?php endif; ?>
						<?php if ($discount_tag > 0) : ?>
							<span class='gspb-c-offer-box__discount'>-<?php echo esc_attr($discount_tag); ?>%</span>
						<?php endif; ?>
						<?php if ($buttonimage) : ?>
							</a>
						<?php endif; ?>
					</div>
				</div>
				<div class="gspb-c-offer-box__column">
					<<?php echo esc_attr($titleTag); ?> class="gspb-c-offer-box__title">
						
							<span <?php echo '' . $schemaname; ?>><?php echo wp_kses_post($name); ?></span>
						
					</<?php echo esc_attr($titleTag); ?>>
					<?php if ((int)$rating > 0) : ?>
						<div aria-label="Rating is <?php echo (float)$rating;?> of 5" class="gspb-c-offer-box__stars" <?php echo '' . $schemarating; ?>>
							<?php if ($schemaenable && !empty($schemafields['count'])) : ?>
								<meta itemprop="reviewCount" content="<?php echo (int)$schemafields['count']; ?>" />
								<meta itemprop="ratingValue" content="<?php echo (float)$rating; ?>" />
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if ($schemaenable && !empty($schemafields['author_review']) && !empty($schemafields['author_review_score'])) : ?>
						<div itemprop="review" itemtype="https://schema.org/Review" itemscope>
							<div itemprop="author" itemtype="https://schema.org/Person" itemscope>
							<meta itemprop="name" content="<?php echo get_the_author_meta('display_name');?>" />
							</div>
							<div itemprop="reviewRating" itemtype="https://schema.org/Rating" itemscope>
							<meta itemprop="ratingValue" content="<?php echo (float)$schemafields['author_review_score']; ?>" />
							<meta itemprop="bestRating" content="5" />
							</div>
						</div>
					<?php endif; ?>
					<?php if($sale_price):?>
					<div class="gspb-c-offer-box__price">
						<span><?php echo esc_attr($sale_price); ?></span>
						<span class="retail-old"><strike><?php echo esc_attr($old_price); ?></strike></span>
					</div>
					<?php endif; ?>
					<div class="gspb-c-offer-box__disclaimer">
						<span><?php echo esc_attr($disclaimer); ?></span>
					</div>
					<div class="priced_block" <?php echo '' . $schemaoffer; ?>>
						<?php if ($schemaenable) : ?>
							<meta itemprop="availability" content="https://schema.org/InStock" />
							<meta itemprop="priceCurrency" content="<?php echo esc_attr($schemafields['currency']); ?>" />
							<meta itemprop="itemCondition" content="https://schema.org/NewCondition" />
							<?php if (!empty($schemafields['price'])) : ?>
								<?php $schemaprice = $schemafields['price']; ?>
							<?php else : ?>
								<?php $schemaprice = (float)$sale_price; ?>
							<?php endif; ?>
							<meta itemprop="price" content="<?php echo esc_attr($schemaprice); ?>" />
							<?php if (!empty($schemafields['valid'])) : ?>
								<meta itemprop="priceValidUntil" content="<?php echo esc_attr($schemafields['valid']); ?>" />
							<?php elseif (!empty($expiration_date)) : ?>
								<meta itemprop="priceValidUntil" content="<?php echo esc_attr($expiration_date); ?>" />
							<?php endif; ?>
						<?php endif; ?>
						<div>
							<a class="gspb_track_btn re_track_btn gspb_offer_block" href="<?php echo esc_url($urllink); ?>" <?php echo '' . $urltarget; ?><?php echo '' . $urlrel; ?><?php echo '' . $schemaurl; ?>>
								<?php echo esc_attr($buttontxt); ?>
							</a>
						</div>
						<?php if ($coupon_code) : ?>
							<div class="gspb_offer_coupon <?php echo '' . $coupon_style; ?>">
								<input class="coupon_text" readonly value="<?php echo esc_attr($coupon_code); ?>" />
								<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 480 480">
									<g>
										<g>
											<rect x="144" y="264" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="144" y="296" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="144" y="328" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="144" y="232" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="144" y="200" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="144" y="168" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="144" y="136" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="32" y="136" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="432" y="136" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="432" y="328" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<rect x="32" y="328" width="16" height="16" />
										</g>
									</g>
									<g>
										<g>
											<path d="M472,200c4.418,0,8-3.582,8-8v-80c0-4.418-3.582-8-8-8H8c-4.418,0-8,3.582-8,8v80c0,4.418,3.582,8,8,8 c22.091,0,40,17.909,40,40s-17.909,40-40,40c-4.418,0-8,3.582-8,8v80c0,4.418,3.582,8,8,8h464c4.418,0,8-3.582,8-8v-80 c0-4.418-3.582-8-8-8c-22.091,0-40-17.909-40-40S449.909,200,472,200z M416.524,247.956c3.532,24.61,22.867,43.944,47.476,47.476 V360H16v-64.568c30.614-4.394,51.87-32.773,47.476-63.388C59.944,207.435,40.61,188.1,16,184.568V120h448v64.568 C433.386,188.962,412.13,217.341,416.524,247.956z" />
										</g>
									</g>
									<g>
										<g>
											<path d="M240,160c-17.673,0-32,14.327-32,32s14.327,32,32,32c17.673,0,32-14.327,32-32S257.673,160,240,160z M240,208 c-8.837,0-16-7.163-16-16s7.163-16,16-16s16,7.163,16,16S248.837,208,240,208z" />
										</g>
									</g>
									<g>
										<g>
											<path d="M336,256c-17.673,0-32,14.327-32,32c0,17.673,14.327,32,32,32c17.673,0,32-14.327,32-32C368,270.327,353.673,256,336,256z M336,304c-8.837,0-16-7.163-16-16s7.163-16,16-16s16,7.163,16,16S344.837,304,336,304z" />
										</g>
									</g>
									<g>
										<g>
											<rect x="197.494" y="231.982" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -85.3385 273.9377)" width="181.017" height="16" />
										</g>
									</g>
								</svg>
							</div>
						<?php endif; ?>
						<?php if (isset($coupon_text)) : ?><div class="time_offer"><?php echo '' . $coupon_text; ?></div><?php endif; ?>
					</div>
					<?php if($enableMultiple):?>
						<div class="gspb-scorebox__buttons">
						<?php

						foreach ($buttons as $index=>$button){
							$bgssolor = (!empty($button['bgssolor'])) ? $button['bgssolor'] : '';
							$bggradient = (!empty($button['bggradient'])) ? $button['bggradient'] : '';
							$radius = (!empty($button['radius'])) ? $button['radius'] : '';
							$textcolor = (!empty($button['textcolor'])) ? $button['textcolor'] : '';
							$urltarget = (!empty($button['newTab'])) ? ' target="_blank"' : '';
							if(!empty($button['sponsored']) || !empty($button['noFollow'])){
								$urlrel = ' rel="';
								if(!empty($button['sponsored'])){
									$urlrel .= 'sponsored';
								}
								if(!empty($button['noFollow'])){
									$urlrel .= ' nofollow';
								}
								$urlrel .= '"';
							}else{
								$urlrel = '';
							}
							$btntitle = (!empty($button['btntitle'])) ? $button['btntitle'] : '';
							$url = (!empty($button['url'])) ? $button['url'] : '';
							$urllink = apply_filters('greenshiftseo_url_filter', $url);
							$urllink = apply_filters('rh_post_offer_url_filter', $urllink);
							
							echo '<a class="gspb_track_btn re_track_btn gspb-scorebox__button" style="background-color: '.esc_attr($bgssolor).'; color: '.esc_attr($textcolor).'; background-image: '.esc_attr($bggradient).'; border-radius: '.(int)$radius.'px" href="'.esc_url($urllink).'"'.$urltarget.$urlrel.'>';
								echo '<span>'.wp_kses_post($btntitle).'</span>';
							echo '</a>';
						}
						?>
						</div>
					<?php endif;?>
					<div class="gspb-c-offer-box__desc">
						<span <?php echo '' . $schemadescription; ?>><?php echo wp_kses_post($description); ?></span>
					</div>
					<?php if ($schemaenable) : ?>
						<div itemprop="brand" itemtype="http://schema.org/Brand" itemscope>
							<meta itemprop="name" content="<?php echo esc_attr($schemafields['brand']); ?>" />
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>

<?php
		$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}
}

new OfferBox;
