<?php
/**
 * Plugin Name: GreenShift Marketing and SEO Addon
 * Description: Build most advanced CTA blocks, offerboxes, listings
 * Author: Wpsoul
 * Author URI: https://wpsoul.com
 * Text Domain: greenshiftseo
 * Version: 1.0.2
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define Dir URL
define('GREENSHIFTSEO_DIR_URL', plugin_dir_url(__FILE__));
define( 'GREENSHIFTSEO_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'GREENSHIFTSEO_PLUGIN_VER', '1.0.2' );

function gspb_seo_is_parent_active()
{
	$active_plugins = get_option('active_plugins', array());

	if (is_multisite()) {
		$network_active_plugins = get_site_option('active_sitewide_plugins', array());
		$active_plugins         = array_merge($active_plugins, array_keys($network_active_plugins));
	}

	foreach ($active_plugins as $basename) {
		if (
			0 === strpos($basename, 'greenshift-animation-and-page-builder-blocks/') ||
			0 === strpos($basename, 'greenshift/')
		) {
			return true;
		}
	}

	return false;
}

if (gspb_seo_is_parent_active()) {
	if (!defined('EDD_CONSTANTS')) {
		require_once GREENSHIFT_DIR_PATH . 'edd/edd_constants.php';
	}

	add_filter( 'plugins_api', 'greenshiftseo_plugin_info', 20, 3 );
    add_filter( 'site_transient_update_plugins', 'greenshiftseo_push_update' );
    add_action( 'upgrader_process_complete', 'greenshiftseo_after_update', 10, 2 );
	add_action( 'after_plugin_row_' . plugin_basename(__FILE__), 'greenshiftseo_after_plugin_row', 10, 3 );

	// Hook: Editor assets.
	add_action('enqueue_block_editor_assets', 'greenShiftSeo_editor_assets');
} else {
	add_action('admin_notices', 'greenshiftseo_admin_notice_warning');
}

//////////////////////////////////////////////////////////////////
// Plugin updater
//////////////////////////////////////////////////////////////////

function greenshiftseo_after_plugin_row( $plugin_file, $plugin_data, $status ) {
    $licenses = greenshift_edd_check_all_licenses();
	$is_active = (((!empty($licenses['all_in_one']) && $licenses['all_in_one'] == 'valid') || (!empty($licenses['seo_addon']) && $licenses['seo_addon'] == 'valid') || (!empty($licenses['all_in_one_seo']) && $licenses['all_in_one_seo'] == 'valid') )) ? true : false;
    if(!$is_active){
        echo sprintf( '<tr class="active"><td colspan="4">%s <a href="%s">%s</a></td></tr>', 'Please enter a license to receive automatic updates', esc_url( admin_url('admin.php?page=' . EDD_GSPB_PLUGIN_LICENSE_PAGE) ), 'Enter License.' );
    }
}

function greenshiftseo_plugin_info( $res, $action, $args ) {

    // do nothing if this is not about getting plugin information
    if ($action !== 'plugin_information') {
        return false;
    }

    // do nothing if it is not our plugin
    if (plugin_basename( __DIR__ ) !== $args->slug) {
        return $res;
    }

    // trying to get from cache first, to disable cache comment 23,33,34,35,36
    if (false == $remote = get_transient( 'greenshiftseo_upgrade_pluginslug' )) {

        // info.json is the file with the actual information about plug-in on your server
        $remote = wp_remote_get( EDD_GSPB_STORE_URL_UPDATE.'/get-info.php?slug='.plugin_basename( __DIR__ ).'&action=info', array(
            'timeout' => 15,
            'headers' => array(
                'Accept' => 'application/json'
            ))
        );

        if (!is_wp_error( $remote ) && isset( $remote[ 'response' ][ 'code' ] ) && $remote[ 'response' ][ 'code' ] == 200 && !empty( $remote[ 'body' ] )) {
            set_transient( 'greenshiftseo_upgrade_pluginslug', $remote, 60000 );
        }else{
			set_transient( 'greenshiftseo_upgrade_pluginslug', 'error', 60000 );
		}
    }

    if ($remote && !is_wp_error( $remote ) && $remote !== 'error' && isset($remote->version)) {

        $remote = json_decode( wp_remote_retrieve_body($remote) );

        $res = new stdClass();
        $res->name = $remote->name;
        $res->slug = $remote->slug;
        $res->version = $remote->version;
        $res->tested = $remote->tested;
        $res->requires = $remote->requires;
        $res->author = $remote->author;
        $res->author_profile = $remote->author_homepage;
        $res->download_link = $remote->download_link;
        $res->trunk = $remote->download_link;
        $res->last_updated = $remote->last_updated;
        
        if(isset($remote->sections)){
            $res->sections = array(
                'description' => $remote->sections->description, // description tab
                'installation' => $remote->sections->installation, // installation tab
                'changelog' => isset($remote->sections->changelog) ? $remote->sections->changelog : '',
            );
        }
        if(isset($remote->banners)){
            $res->banners = array(
                'low' => $remote->banners->low,
                'high' => $remote->banners->high,
            );
        }

        return $res;
    }

    return false;
}

function greenshiftseo_push_update( $transient ) {

    if (empty( $transient->checked )) {
        return $transient;
    }

    // trying to get from cache first, to disable cache comment 11,20,21,22,23
    if (false == $remote = get_transient( 'greenshiftseo_upgrade_pluginslug' )) {
        // info.json is the file with the actual plugin information on your server
        $remote = wp_remote_get( EDD_GSPB_STORE_URL_UPDATE.'/get-info.php?slug='.plugin_basename( __DIR__ ).'&action=info', array(
            'timeout' => 10,
            'headers' => array(
                'Accept' => 'application/json'
            ))
        );

        if (!is_wp_error( $remote ) && isset( $remote[ 'response' ][ 'code' ] ) && $remote[ 'response' ][ 'code' ] == 200 && !empty( $remote[ 'body' ] )) {
            set_transient( 'greenshiftseo_upgrade_pluginslug', $remote, 60000 );
        } else{
			set_transient( 'greenshiftseo_upgrade_pluginslug', 'error', 60000 );
		}
    }

    if (!is_wp_error( $remote ) && $remote && $remote !== 'error') {

        $remote = json_decode( $remote[ 'body' ] );

        // your installed plugin version should be on the line below! You can obtain it dynamically of course
        if ($remote && isset($remote->version) && version_compare( GREENSHIFTSEO_PLUGIN_VER, $remote->version, '<' ) && version_compare( $remote->requires, get_bloginfo( 'version' ), '<' )) {
            $res = new stdClass();
            $res->slug = plugin_basename( __DIR__ );
            $res->plugin = plugin_basename( __FILE__ ); // it could be just pluginslug.php if your plugin doesn't have its own directory
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $licenses = greenshift_edd_check_all_licenses();
            $is_active = (((!empty($licenses['all_in_one']) && $licenses['all_in_one'] == 'valid') || (!empty($licenses['seo_addon']) && $licenses['seo_addon'] == 'valid') || (!empty($licenses['all_in_one_seo']) && $licenses['all_in_one_seo'] == 'valid') )) ? true : false;
            if($is_active){
                $res->package = $remote->download_link;
            }
            $transient->response[ $res->plugin ] = $res;
            //$transient->checked[$res->plugin] = $remote->version;
        }
    }
    return $transient;
}

function greenshiftseo_after_update( $upgrader_object, $options ) {
    if ($options[ 'action' ] == 'update' && $options[ 'type' ] === 'plugin') {
        // just clean the cache when new plugin version is installed
        delete_transient( 'greenshiftseo_upgrade_pluginslug' );
    }
}

function greenshiftseo_admin_notice_warning()
{
?>
	<div class="notice notice-warning">
		<p><?php printf(__('Please, activate %s plugin to use SEO Addon'), '<a href="https://wordpress.org/plugins/greenshift-animation-and-page-builder-blocks" target="_blank">Greenshift</a>'); ?></p>
	</div>
<?php
}

function greenshiftseo_change_action_links($links)
{

	$links = array_merge(array(
		'<a href="https://greenshiftwp.com/changelog" style="color:#93003c" target="_blank">' . __('What\'s New', 'greenshiftseo') . '</a>'
	), $links);

	return $links;
}
add_action('plugin_action_links_' . plugin_basename(__FILE__), 'greenshiftseo_change_action_links');



/**
 * GreenShift Blocks Category
 */
if(!function_exists('gspb_greenShiftSeo_category')){
	function gspb_greenShiftSeo_category( $categories, $post ) {
		return array_merge(
			array(
				array(
					'slug'  => 'Greenshiftseo',
					'title' => __( 'GreenShift Marketing and Seo'),
				),
			),
			$categories
		);
	}
}
add_filter( 'block_categories_all', 'gspb_greenShiftSeo_category', 1, 2 );


/* Include rewrite links functions. */
add_action('init', 'init_rewrite_functions', 999);
function init_rewrite_functions() {
	require_once GREENSHIFTSEO_DIR_PATH .'includes/rewrite-links/class-gspbcal.php';
	$gspbcal = new Gspbcal( '1.0' );
}

//register blocks on with server side
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/comparison-table/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/comparison-item/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/howto/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/howtoitem/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/event/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/offerbox/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/offerlisting/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/offerlistingfull/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/popupbutton/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/reviewbox/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/scorebox/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/slider/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/wcbox/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/wclist/block.php';
require_once GREENSHIFTSEO_DIR_PATH .'blockrender/hotspot/block.php';

//////////////////////////////////////////////////////////////////
// Functions to render conditional scripts
//////////////////////////////////////////////////////////////////

// Hook: Frontend assets.
add_action('init', 'greenShiftSeo_register_scripts_blocks');
add_filter('render_block', 'greenShiftSeo_block_script_assets', 10, 2);


if(!function_exists('greenShiftSeo_register_scripts_blocks')){
	function greenShiftSeo_register_scripts_blocks()
	{
		wp_register_script(
			'gssequalizer',
			GREENSHIFTSEO_DIR_URL . 'assets/comparison/equalizer.js',
			array(),
			'1.0',
			true
		);
		wp_register_style(
			'gsstooltip',
			GREENSHIFTSEO_DIR_URL . 'assets/extra/tooltip.css',
			array(),
			'1.0'
		);
		wp_register_script(
			'gsstabsjs',
			GREENSHIFTSEO_DIR_URL . 'assets/tabs/tabs.js',
			array(),
			'1.0',
			true
		);
		wp_register_script(
			'gsspopupbuttonjs',
			GREENSHIFTSEO_DIR_URL . 'assets/popupbutton/index.js',
			array(),
			'1.0',
			true
		);
		wp_register_script(
			'gssgutsliderjs',
			GREENSHIFTSEO_DIR_URL . 'assets/slider/index.js',
			array(),
			'1.0',
			true
		);
		wp_register_script(
			'gssextsource',
			GREENSHIFTSEO_DIR_URL . 'assets/formatsource/index.js',
			array(),
			'1.0',
			true
		);
		wp_register_script(
			'gsstoggler',
			GREENSHIFTSEO_DIR_URL . 'assets/toggle/toggle.js',
			array(),
			'1.0',
			true
		);
		wp_register_style( 'gsseoswiper',  GREENSHIFTSEO_DIR_URL.'assets/swiper/swiper-bundle.min.css', array(), '7.0' );
		wp_register_script( 'gsseoswiper',  GREENSHIFTSEO_DIR_URL.'assets/swiper/swiper-bundle.min.js', array(), '7.0', true );

		wp_register_script( 'gspbextsource',  GREENSHIFTSEO_DIR_URL.'assets/formatsource/index.js', array(), '1.0', true );

		// hotspot init
		wp_register_script(
			'gs-hotspot',
			GREENSHIFTSEO_DIR_URL . 'libs/hotspot/index.js',
			array(),
			'1.4',
			true
		);

	}
}

if(!function_exists('greenShiftSeo_block_script_assets')){
	function greenShiftSeo_block_script_assets($html, $block)
	{
		// phpcs:ignore
	
		//Main styles for blocks are loaded via Redux. Can be found in src/customJS/editor/store/index.js and src/gspb-library/helpers/reusable_block_css/index.js
	
		if(!is_admin()){

			// looking for seo Flip
			if ($block['blockName'] === 'greenshift-blocks/event') {
				wp_enqueue_script('gsslightboxfront');
				wp_enqueue_style('gsslightboxfront');
			}else if($block['blockName'] === 'greenshift-blocks/comparison-table'){
				wp_enqueue_script('gssequalizer');
				if(isset( $block['attrs']['responsiveView']) && $block['attrs']['responsiveView'] == 'slide'){
					wp_enqueue_style('gsseoswiper');
					wp_enqueue_script('gsseoswiper');
				}
				
			}else if($block['blockName'] === 'greenshift-blocks/wcbox'){
				wp_enqueue_script('gsstabsjs');
				wp_enqueue_script('gsslightboxfront');
				wp_enqueue_style('gsslightboxfront');
			}else if($block['blockName'] === 'greenshift-blocks/popupbutton'){
				wp_enqueue_script('gsspopupbuttonjs');
			}else if($block['blockName'] === 'greenshift-blocks/slider'){
				wp_enqueue_script('gssgutsliderjs');
				wp_enqueue_script('gsslightboxfront');
				wp_enqueue_style('gsslightboxfront');
			}else if($block['blockName'] === 'greenshift-blocks/offerlistingfull'){
				if(!empty( $block['attrs']['enableexpand'])){
					wp_enqueue_script('gsstoggler');
				}
			}

			if(false !== strpos( json_encode($block), 'gspb-ext-source' )){
				wp_enqueue_script( 'gspbextsource');
			}

			// looking for hotspot
			if ($block['blockName'] === 'greenshift-blocks/hotspot') {
				wp_enqueue_script('gs-hotspot');
			}

		}
	
	
		return $html;
	}
}

//////////////////////////////////////////////////////////////////
// Enqueue Gutenberg block assets for backend editor.
//////////////////////////////////////////////////////////////////

if(!function_exists('greenShiftSeo_editor_assets')){
	function greenShiftSeo_editor_assets()
	{
		// phpcs:ignor
	
		$index_asset_file = include(GREENSHIFTSEO_DIR_PATH . 'build/index.asset.php');
	
	
		// Blocks Assets Scripts
		wp_enqueue_script(
			'greenShiftSeo-block-js', // Handle.
			GREENSHIFTSEO_DIR_URL . 'build/index.js',
			array('greenShift-editor-js', 'greenShift-library-script', 'wp-block-editor', 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor', 'wp-data'),
			$index_asset_file['version'],
			true
		);

		$licenses = greenshift_edd_check_all_licenses();
		$is_active = (((!empty($licenses['all_in_one']) && $licenses['all_in_one'] == 'valid') || (!empty($licenses['seo_addon']) && $licenses['seo_addon'] == 'valid') || (!empty($licenses['all_in_one_seo']) && $licenses['all_in_one_seo'] == 'valid') )) ? true : false;

		$check = '';
		if ($is_active) {
			$check = 1;
		}
		$lc = array( 'can_use_premium_code' => $check );
		wp_localize_script('greenShiftSeo-block-js', 'greenshiftSEO', $lc);
		
	
		// Styles.
	
		wp_enqueue_style(
			'greenShiftSeo-block-css', // Handle.
			GREENSHIFTSEO_DIR_URL . 'build/index.css', // Block editor CSS.
			array('greenShift-library-editor', 'wp-edit-blocks'),
			$index_asset_file['version']
		);

	}
}

require_once GREENSHIFTSEO_DIR_PATH .'class-rest.php';


//////////////////////////////////////////////////////////////////
// Patterns
//////////////////////////////////////////////////////////////////
//require_once GREENSHIFTSEO_DIR_PATH . 'patterns.php';


//////////////////////////////////////////////////////////////////
// Localization
//////////////////////////////////////////////////////////////////
//function greenshiftseo_plugin_load_textdomain() {
    //load_plugin_textdomain('greenshiftseo', false, GREENSHIFTSEO_DIR_URL . 'languages');
//}
//add_action('init', 'greenshiftseo_plugin_load_textdomain');