/*! http://keith-wood.name/signature.html
	Signature plugin for jQuery UI v1.2.1.
	Requires excanvas.js in IE.
	Written by Keith Wood (wood.keith{at}optusnet.com.au) April 2012.
	Available under the MIT (http://keith-wood.name/licence.html) license. 
	Please attribute the author if you use it. */
!function(n){"use strict";var t={options:{distance:0,background:"#fff",color:"#000",thickness:2,guideline:!1,guidelineColor:"#a0a0a0",guidelineOffset:50,guidelineIndent:10,notAvailable:"Your browser doesn't support signing",scale:1,syncField:null,syncFormat:"JSON",svgStyles:!1,change:null},_create:function(){this.element.addClass(this.widgetFullName||this.widgetBaseClass);try{this.canvas=n('<canvas width="'+this.element.width()+'" height="'+this.element.height()+'">'+this.options.notAvailable+"</canvas>")[0],this.element.append(this.canvas)}catch(t){n(this.canvas).remove(),this.resize=!0,this.canvas=document.createElement("canvas"),this.canvas.setAttribute("width",this.element.width()),this.canvas.setAttribute("height",this.element.height()),this.canvas.innerHTML=this.options.notAvailable,this.element.append(this.canvas),G_vmlCanvasManager&&G_vmlCanvasManager.initElement(this.canvas)}this.ctx=this.canvas.getContext("2d"),this._refresh(!0),this._mouseInit()},_refresh:function(t){var i;this.resize&&(i=n(this.canvas),n("div",this.canvas).css({width:i.width(),height:i.height()})),this.ctx.fillStyle=this.options.background,this.ctx.strokeStyle=this.options.color,this.ctx.lineWidth=this.options.thickness,this.ctx.lineCap="round",this.ctx.lineJoin="round",this.clear(t)},clear:function(t){this.options.disabled||(this.ctx.clearRect(0,0,this.element.width(),this.element.height()),this.ctx.fillStyle=this.options.background,this.ctx.fillRect(0,0,this.element.width(),this.element.height()),this.options.guideline&&(this.ctx.save(),this.ctx.strokeStyle=this.options.guidelineColor,this.ctx.lineWidth=1,this.ctx.beginPath(),this.ctx.moveTo(this.options.guidelineIndent,this.element.height()-this.options.guidelineOffset),this.ctx.lineTo(this.element.width()-this.options.guidelineIndent,this.element.height()-this.options.guidelineOffset),this.ctx.stroke(),this.ctx.restore()),this.lines=[],t||this._changed())},_changed:function(t){if(this.options.syncField){var i="";switch(this.options.syncFormat){case"PNG":i=this.toDataURL();break;case"JPEG":i=this.toDataURL("image/jpeg");break;case"SVG":i=this.toSVG();break;default:i=this.toJSON()}n(this.options.syncField).val(i)}this._trigger("change",t,{})},_setOptions:function(){this._superApply?this._superApply(arguments):n.Widget.prototype._setOptions.apply(this,arguments);var t,i=0,s=!0;for(t in arguments[0])arguments[0].hasOwnProperty(t)&&(i++,s=s&&"disabled"===t);(1<i||!s)&&this._refresh()},_mouseCapture:function(){return!this.options.disabled},_mouseStart:function(t){this.offset=this.element.offset(),this.offset.left-=document.documentElement.scrollLeft||document.body.scrollLeft,this.offset.top-=document.documentElement.scrollTop||document.body.scrollTop,this.lastPoint=[this._round(t.clientX-this.offset.left),this._round(t.clientY-this.offset.top)],this.curLine=[this.lastPoint],this.lines.push(this.curLine)},_mouseDrag:function(t){t=[this._round(t.clientX-this.offset.left),this._round(t.clientY-this.offset.top)];this.curLine.push(t),this.ctx.beginPath(),this.ctx.moveTo(this.lastPoint[0],this.lastPoint[1]),this.ctx.lineTo(t[0],t[1]),this.ctx.stroke(),this.lastPoint=t},_mouseStop:function(t){1===this.curLine.length&&(t.clientY+=this.options.thickness,this._mouseDrag(t)),this.lastPoint=null,this.curLine=null,this._changed(t)},_round:function(t){return Math.round(100*t)/100},toJSON:function(){return'{"lines":['+n.map(this.lines,function(t){return"["+n.map(t,function(t){return"["+t+"]"})+"]"})+"]}"},toSVG:function(){var t=this.options.svgStyles?'style="fill: '+this.options.background+';"':'fill="'+this.options.background+'"',i=this.options.svgStyles?'style="fill: none; stroke: '+this.options.color+"; stroke-width: "+this.options.thickness+';"':'fill="none" stroke="'+this.options.color+'" stroke-width="'+this.options.thickness+'"';return'<?xml version="1.0"?>\n<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n<svg xmlns="http://www.w3.org/2000/svg" width="15cm" height="15cm">\n\t<g '+t+'>\n\t\t<rect x="0" y="0" width="'+this.canvas.width+'" height="'+this.canvas.height+'"/>\n\t\t<g '+i+">\n"+n.map(this.lines,function(t){return'\t\t\t<polyline points="'+n.map(t,function(t){return t+""}).join(" ")+'"/>\n'}).join("")+"\t\t</g>\n\t</g>\n</svg>\n"},toDataURL:function(t,i){return this.canvas.toDataURL(t,i)},draw:function(t){this.options.disabled||(this.clear(!0),"string"==typeof t&&0===t.indexOf("data:")?this._drawDataURL(t,this.options.scale):"string"==typeof t&&-1<t.indexOf("<svg")?this._drawSVG(t,this.options.scale):this._drawJSON(t,this.options.scale),this._changed())},_drawJSON:function(t,i){"string"==typeof t&&(t=n.parseJSON(t)),this.lines=t.lines||[];var s=this.ctx;n.each(this.lines,function(){s.beginPath(),n.each(this,function(t){s[0===t?"moveTo":"lineTo"](this[0]*i,this[1]*i)}),s.stroke()})},_drawSVG:function(t,i){var e=this.lines=[];n(t).find("polyline").each(function(){var s=[];n.each(n(this).attr("points").split(" "),function(t,i){i=i.split(",");s.push([parseFloat(i[0]),parseFloat(i[1])])}),e.push(s)});var s=this.ctx;n.each(this.lines,function(){s.beginPath(),n.each(this,function(t){s[0===t?"moveTo":"lineTo"](this[0]*i,this[1]*i)}),s.stroke()})},_drawDataURL:function(t,i){var s=new Image,e=this.ctx;s.onload=function(){e.drawImage(this,0,0,s.width*i,s.height*i)},s.src=t},isEmpty:function(){return 0===this.lines.length},_destroy:function(){this.element.removeClass(this.widgetFullName||this.widgetBaseClass),n(this.canvas).remove(),this.canvas=this.ctx=this.lines=null,this._mouseDestroy()}};n.Widget.prototype._destroy||n.extend(t,{destroy:function(){this._destroy(),n.Widget.prototype.destroy.call(this)}}),n.Widget.prototype._getCreateOptions===n.noop&&n.extend(t,{_getCreateOptions:function(){return n.metadata&&n.metadata.get(this.element[0])[this.widgetName]}}),n.widget("kbw.signature",n.ui.mouse,t),n.kbw.signature.options=n.kbw.signature.prototype.options}(jQuery);	//# sourceMappingURL=jquery.signature.min.map