<?php
namespace AcademyProAssignments;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Helper {
	public static function prepare_submitted_assignment_item( $submitted_assignment ) {
		$submitted_assignment->post_title = html_entity_decode( get_the_title( $submitted_assignment->comment_post_ID ) );
		$submitted_assignment->academy_assignment_settings = get_post_meta( $submitted_assignment->comment_post_ID, 'academy_assignment_settings', true );
		$submitted_assignment->academy_assignment_enable_resubmit = (bool) get_post_meta( $submitted_assignment->comment_post_ID, 'academy_assignment_enable_resubmit', true );
		$submitted_assignment->academy_assignment_resubmit_limit = get_post_meta( $submitted_assignment->comment_post_ID, 'academy_assignment_resubmit_limit', true ) ?? 0;
		$submitted_assignment->meta = array(
			'academy_pro_assignment_start_time' => get_comment_meta( $submitted_assignment->comment_ID, 'academy_pro_assignment_start_time', true ),
			'academy_pro_assignment_end_time' => get_comment_meta( $submitted_assignment->comment_ID, 'academy_pro_assignment_end_time', true ),
			'academy_pro_assignment_attachment' => (int) get_comment_meta( $submitted_assignment->comment_ID, 'academy_pro_assignment_attachment', true ),
			'academy_pro_assignment_evaluate_point' => (int) get_comment_meta( $submitted_assignment->comment_ID, 'academy_pro_assignment_evaluate_point', true ),
			'academy_pro_assignment_evaluate_feedback' => get_comment_meta( $submitted_assignment->comment_ID, 'academy_pro_assignment_evaluate_feedback', true ),
		);
		return $submitted_assignment;
	}
	public static function prepare_submitted_assignment_items( $submitted_assignments ) {
		$response = [];
		foreach ( $submitted_assignments as $submitted_assignment ) {
			$response[] = self::prepare_submitted_assignment_item( $submitted_assignment );
		}
		return $response;
	}
	public static function get_hours_from_submission_time( $number, $unit ) {
		$hours = $number;
		if ( 'weeks' === $unit ) {
			$hours = $number * 7 * 24;
			return $hours .= ' hours';
		} elseif ( 'days' === $unit ) {
			$hours = $number * 24;
			return $hours .= ' hours';
		}
		if ( $hours <= 1 ) {
			return $hours . ' hour';
		}
		return $hours . ' hours';
	}
	public static function is_assignment_submission_expired( $assignment, $time_zone ) {
		if ( 0 !== $assignment->settings['submission_time'] && $assignment->submitted_assignment && 'submitting' === $assignment->submitted_assignment->comment_approved ) {
			$assignment_duration_hours = self::get_hours_from_submission_time( $assignment->settings['submission_time'], $assignment->settings['submission_time_unit'] );
			$assignment_last_submission_time = strtotime( $assignment->submitted_assignment->meta['academy_pro_assignment_start_time'] . "+ $assignment_duration_hours" );
			$current_time = strtotime( wp_date( 'Y-m-d H:i:s', null, new \DateTimeZone( $time_zone ) ) );
			$assignment->last_submission_timestamp = $assignment_last_submission_time;
			if ( $assignment_last_submission_time < $current_time ) {
				return true;
			}
		}
		return false;
	}
	public static function has_submitted_assignment( $course_id, $user_id ) {
		$submitted_assignments = get_comments(array(
			'post_id' => $course_id,
			'comment_type' => 'academy_assignments',
			'user_id'   => $user_id,
			'status' => array( 'submitted', 'pass', 'failed' ),
			'number' => 1
		));
		return $submitted_assignments;
	}
	public static function render_assignment_for_php_rendering( $course_id, $assignment_id ) {
		$course_id     = (int) sanitize_text_field( $course_id );
		$assignment_id = (int) sanitize_text_field( $assignment_id );
		$time_zone     = date_default_timezone_get();
		$user_id       = (int) get_current_user_id();

		$has_permission = \Academy\Helper::has_permission_to_access_curriculum( $course_id );

		if ( $has_permission ) {
			do_action( 'academy_pro_assignments/frontend/before_render_assignment', $course_id, $assignment_id );
			$assignment = get_post( $assignment_id );
			if ( ! $assignment ) {
				return esc_html__( 'Sorry, something went wrong!', 'academy-pro' );
			}
			$assignment->post_content_rendered = \Academy\Helper::get_content_html( stripslashes( $assignment->post_content ) );
			$attachment_id = (int) get_post_meta( $assignment_id, 'academy_assignment_attachment', true );
			$assignment->attachment = [
				'ID' => $attachment_id ? $attachment_id : (int) get_post_meta( $assignment_id, '_thumbnail_id', true ),
				'url' => $attachment_id ? wp_get_attachment_url( $attachment_id ) : '',
				'title' => $attachment_id ? get_the_title( $attachment_id ) : '',
			];
			$assignment->settings = get_post_meta( $assignment_id, 'academy_assignment_settings', true );
			$submitted_assignments = get_comments(array(
				'post_id' => $assignment->ID,
				'comment_type' => 'academy_assignments',
				'parent'    => $course_id,
				'user_id'   => $user_id,
				'status' => array( 'submitted', 'submitting', 'pass', 'failed' )
			));
			if ( $submitted_assignments ) {
				$submitted_assignments = self::prepare_submitted_assignment_items( $submitted_assignments );
				$assignment->submitted_assignment = current( $submitted_assignments );
			}
			$assignment->submission_status = 'active';
			if ( self::is_assignment_submission_expired( $assignment, $time_zone ) ) {
				$assignment->submission_status = 'expired';
			}
			$data = apply_filters( 'academy_pro_assignments/frontend/berfore_render_result', $assignment, $course_id, $user_id, $assignment_id );
			return $data;
		}//end if
		return esc_html__( 'Access Denied', 'academy-pro' );
	}
	public static function get_the_remaining_time_of_an_assignment_in_php_render( $time, $count, $assignment ) {
		$unit = strtoupper( $assignment->settings['submission_time_unit'][0] );
		$current_time = new \DateTime();
		$interval = ( 'H' === $unit ) ? "PT{$count}{$unit}" : "P{$count}{$unit}";
		$given_time = ( new \DateTime( $time ) )->add( new \DateInterval( $interval ) );
		$diff = $current_time->diff( $given_time );

		if ( $current_time > $given_time ) {
			$diff->invert = 1;
		}

		return $diff;
	}

	public static function get_date_time_translations( $unit ) {
		switch ( $unit ) {
			case 'weeks':
				return __( 'Weeks', 'academy-pro' );
			case 'days':
				return __( 'Days', 'academy-pro' );
			case 'hours':
				return __( 'Hours', 'academy-pro' );
			default:
				return $unit;
		}
	}
}
