<?php

namespace AcademyProBuddyboss;

use AcademyProBuddyboss\Activities\{
	LessionActivity,
	QuestionAndAnswerActivity,
	AnnouncementsActivity,
	CourseActivity,
	QuizActivity
};

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class ActivityRegistration {

	public static function init() : void {

		$instance = new self();

		$instance->register_activities();
	}

	public function register_activities() : void {
		CourseActivity::init();
		LessionActivity::init();
		AnnouncementsActivity::init();
		QuestionAndAnswerActivity::init();
		QuizActivity::init();
	}

	public static function get_assigned_groups( int $course_id ) {
		return get_post_meta( $course_id, 'assigned_buddyboss_groups', true );
	}

	public static function get_status( int $course_id ) {
		return get_post_meta( $course_id, 'is_buddyboss_notification_active', true );
	}

}
