<?php

namespace AcademyProBuddypress;

use AcademyProBuddypress\Activities\{
	LessonActivity,
	QuestionAndAnswerActivity,
	AnnouncementsActivity,
	CourseActivity,
	QuizActivity
};

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class ActivityRegistration {


	public static function init() : void {

		$instance = new self();

		$instance->register_activities();
	}



	public function register_activities() : void {
		CourseActivity::init();
		LessonActivity::init();
		AnnouncementsActivity::init();
		QuestionAndAnswerActivity::init();
		QuizActivity::init();
	}


	public static function get_assigned_groups( int $course_id ) {
		return get_post_meta( $course_id, 'assigned_buddypress_groups', true );
	}


	public static function get_status( int $course_id ) {
		return get_post_meta( $course_id, 'is_buddypress_notification_active', true );
	}

}
