<?php

namespace AcademyProCalendar\Frontend;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class EnqueScripts {

	public static function init(): void {
		$instance = new self();
		add_action( 'wp_enqueue_scripts', [ $instance, 'load_js' ] );
	}

	public function load_js() {
		wp_enqueue_script(
			'academy-event-calendar-js',
			ACADEMY_PRO_PLUGIN_ROOT_URI . 'addons/calendar/assets/js/script.js',
			[ 'jquery' ],
			filemtime( __DIR__ . '/../assets/js/script.js' ), true
		);
	}
}
