<?php
namespace  AcademyProCertificates;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Helper {
	public static function get_certificate_verification_hash_by_course_and_student_id( $user_id, $course_id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$comments = $wpdb->get_results( $wpdb->prepare(
			"SELECT comment_content FROM $wpdb->comments WHERE user_id = %d AND comment_post_ID = %d",
			$user_id, $course_id
		) );

		if ( ! empty( $comments ) && isset( $comments[0] ) ) {
			return $comments[0]->comment_content;
		}
	}
	public static function get_course_id_by_meta_key_and_certificate_id( $meta_key, $certificate_id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$post_id = $wpdb->get_var( $wpdb->prepare(
			"SELECT post_id 
            FROM $wpdb->postmeta 
            WHERE meta_key = %s 
            AND meta_value = %s 
            LIMIT 1",
			$meta_key,
			$certificate_id
		));

		return $post_id ? $post_id : false;
	}
}
