<?php
namespace AcademyProContentDrip;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Hooks {
	public static function init() {
		$self = new self();
		add_action( 'academy/frontend/before_render_lesson', array( $self, 'render_drip_lesson' ), 10, 3 );
		add_action( 'academy_quizzes/frontend/before_render_quiz', array( $self, 'render_drip_quiz' ), 10, 2 );
		add_action( 'academy_pro_assignments/frontend/before_render_assignment', array( $self, 'render_drip_assignment' ), 10, 2 );
		add_action( 'academy_pro_tutor_booking/frontend/before_render_booking', array( $self, 'render_drip_booking' ), 10, 2 );
		add_action( 'academy/frontend/before_mark_topic_complete', array( $self, 'before_mark_topic_complete_check_drip_content' ), 10, 4 );

		add_action( 'academy/templates/curriculums/before_render_lesson_content', array( $self, 'lesson_php_render_content_drip' ), 10, 3 );
		add_action( 'academy/templates/curriculums/before_render_quiz_content', array( $self, 'quiz_php_render_content_drip' ), 10, 3 );
		add_action( 'academy/templates/curriculums/before_render_assignment_content', array( $self, 'assignment_php_render_content_drip' ), 10, 3 );
		add_action( 'academy/templates/curriculums/before_render_booking_content', array( $self, 'booking_php_render_content_drip' ), 10, 3 );
	}

	public function lesson_php_render_content_drip( $lesson, $course_id, $topic_id ) {
		$lesson = is_object( $lesson ) ? $lesson : (object) $lesson;
		$drip_content = isset( $lesson->meta['drip_content'] ) ? $lesson->meta['drip_content'] : '';
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'lesson', $lesson->ID, true );
		if ( $has_drip_content ) {
			// hide existing content
			add_filter( 'academy/templates/curriculums/has_access_lesson_content', '__return_false' );
			// show content drip message
			\AcademyPro\Helper::get_template( 'curriculums/content-drip.php',
				$has_drip_content
			);
		}
	}

	public function render_drip_lesson( $lesson, $course_id, $lesson_id ) {
		$lesson = is_object( $lesson ) ? $lesson : (object) $lesson;
		$drip_content = isset( $lesson->meta['drip_content'] ) ? $lesson->meta['drip_content'] : '';
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'lesson', $lesson_id );
		if ( $has_drip_content ) {
			wp_send_json_error( $has_drip_content );
		}
	}

	public function quiz_php_render_content_drip( $quiz, $course_id, $quiz_id ) {
		$drip_content = get_post_meta( $quiz_id, 'academy_quiz_drip_content', true );
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'quiz', $quiz_id );
		if ( $has_drip_content ) {
			// hide existing content
			add_filter( 'academy/templates/curriculums/has_access_quiz_content', '__return_false' );
			// show content drip message
			\AcademyPro\Helper::get_template( 'curriculums/content-drip.php',
				$has_drip_content
			);
		}
	}

	public function render_drip_quiz( $course_id, $quiz_id ) {
		$drip_content = get_post_meta( $quiz_id, 'academy_quiz_drip_content', true );
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'quiz', $quiz_id );
		if ( $has_drip_content ) {
			wp_send_json_error( $has_drip_content );
		}
	}

	public function assignment_php_render_content_drip( $assignment, $course_id, $assignment_id ) {
		$drip_content = get_post_meta( $assignment_id, 'academy_assignment_drip_content', true );
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'assignment', $assignment_id );
		if ( $has_drip_content ) {
			// hide existing content
			add_filter( 'academy/templates/curriculums/has_access_assignment_content', '__return_false' );
			// show content drip message
			\AcademyPro\Helper::get_template( 'curriculums/content-drip.php',
				$has_drip_content
			);
		}
	}

	public function render_drip_assignment( $course_id, $assignment_id ) {
		$drip_content = get_post_meta( $assignment_id, 'academy_assignment_drip_content', true );
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'assignment', $assignment_id );
		if ( $has_drip_content ) {
			wp_send_json_error( $has_drip_content );
		}
	}

	public function render_drip_booking( $course_id, $booking_id ) {
		$drip_content = get_post_meta( $booking_id, '_academy_booking_drip_content', true );
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'booking', $booking_id );
		if ( $has_drip_content ) {
			wp_send_json_error( $has_drip_content );
		}
	}

	public function booking_php_render_content_drip( $calendar_settings, $course_id, $booking_id ) {
		$drip_content = get_post_meta( $booking_id, '_academy_booking_drip_content', true );
		if ( empty( $drip_content ) ) {
			$drip_content = $this->get_default_value();
		}
		$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, 'booking', $booking_id );
		if ( $has_drip_content ) {
			// hide existing content
			add_filter( 'academy/templates/curriculums/has_access_booking_content', '__return_false' );
			// show the drip message
			\AcademyPro\Helper::get_template( 'curriculums/content-drip.php',
				$has_drip_content
			);
		}
	}

	public function before_mark_topic_complete_check_drip_content( $type, $course_id, $topic_id, $user_id ) {
		$drip_content_enabled = (bool) get_post_meta( $course_id, 'academy_course_drip_content_enabled', true );
		$drip_type = get_post_meta( $course_id, 'academy_course_drip_content_type', true );
		if ( ! $drip_content_enabled ) {
			return;
		}
		// check is course drip sequentially
		if ( 'schedule_by_sequentially' === $drip_type && true !== Helper::is_complete_previous_topic( $course_id, $topic_id, $type ) ) {
			if ( \Academy\Helper::get_settings( 'is_enabled_lessons_php_render' ) ) {
				wp_die(
					// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					esc_html__( 'You must complete the previous topic to proceed.', 'academy-pro' ),
					// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					esc_html__( 'Error', 'academy-pro' ),
					array(
						'response' => 403,
						'back_link' => true,
					)
				);
			}
			wp_send_json_error(
				__( 'You must complete the previous topic to proceed.', 'academy-pro' ),
			);
		}

		switch ( $type ) {
			case 'lesson':
				$drip_content = \Academy\Helper::get_lesson_meta( $topic_id, 'drip_content' );
				if ( $drip_content ) {
					$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, $type, $topic_id );
				}
				break;
			case 'quiz':
				$drip_content = get_post_meta( $topic_id, 'academy_quiz_drip_content', true );
				if ( ! empty( $drip_content ) ) {
					$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, $type, $topic_id );
				}
				break;
			case 'assignment':
				$drip_content = get_post_meta( $topic_id, 'academy_assignment_drip_content', true );
				if ( ! empty( $drip_content ) ) {
					$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, $type, $topic_id );
				}
				break;
			case 'booking':
				$drip_content = get_post_meta( $topic_id, '_academy_booking_drip_content', true );
				if ( ! empty( $drip_content ) ) {
					$has_drip_content = $this->drip_content_checker( $drip_content, $course_id, $type, $topic_id );
				}
				break;
		}//end switch

		if ( ! empty( $has_drip_content ) ) {
			wp_send_json_error(
				$has_drip_content['message']
			);
		}
	}

	public function get_default_value() {
		return [
			'schedule_by_date' => '',
			'schedule_by_topic_complete_date' => 0,
			'schedule_by_enroll_date' => 0,
			'schedule_by_prerequisite' => [],
			'schedule_by_topic_unlock_date' => 0,
		];
	}
	public function drip_content_checker( $drip_content, $course_id, $type, $topic_id, $is_php_render = false ) {
		$drip_content_enabled = (bool) get_post_meta( $course_id, 'academy_course_drip_content_enabled', true );
		if ( ! $drip_content_enabled ) {
			return false;
		}
		$drip_content_type = get_post_meta( $course_id, 'academy_course_drip_content_type', true );
		$message = '';
		// check drip content isset or not
		if ( 'schedule_by_date' === $drip_content_type && $drip_content['schedule_by_date'] ) {
			if ( strtotime( $drip_content['schedule_by_date'] ) > wp_date( 'U' ) ) {
				$message = __( 'This content will be accessible on', 'academy-pro' ) . ' ' . gmdate( get_option( 'date_format' ), strtotime( $drip_content['schedule_by_date'] ) );
				return array(
					'message' => $message,
					'type' => $type
				);
			}
		} elseif ( 'schedule_by_topic_complete_date' === $drip_content_type && ! empty( $drip_content['schedule_by_topic_complete_date'] ) ) {
			$is_complete = Helper::is_complete_previous_topic( $course_id, $topic_id, $type );
			if ( ! $is_complete ) {
				return array(
					'message' => __( 'You must complete the previous topic to proceed.', 'academy-pro' ),
					'type' => $type
				);
			}
			$option_name        = 'academy_course_' . $course_id . '_completed_topics';
			$saved_topics_lists = (array) json_decode( get_user_meta( get_current_user_id(), $option_name, true ), true );

			if ( $saved_topics_lists ) {
				foreach ( $saved_topics_lists as $index => $value ) {
					foreach ( $value as $id => $timestamp ) {
						if ( (int) $topic_id === (int) $id && $type === $index ) {
							return false;
						}

						$content_available_date = $timestamp + ( $drip_content['schedule_by_topic_complete_date'] * DAY_IN_SECONDS );
						if ( $content_available_date > wp_date( 'U' ) ) {
							$message = __( 'This content will be accessible on', 'academy-pro' ) . ' ' . gmdate( get_option( 'date_format' ), $content_available_date );
							return array(
								'message' => $message,
								'type'    => $type,
							);
						}
					}
				}
			}
		} elseif ( 'schedule_by_topic_unlock_date' === $drip_content_type && ! empty( $drip_content['schedule_by_topic_unlock_date'] ) ) {
			$is_complete = Helper::is_complete_previous_topic( $course_id, $topic_id, $type );
			if ( ! $is_complete ) {
				return array(
					'message' => __( 'You must complete the previous topic to proceed.', 'academy-pro' ),
					'type' => $type
				);
			}
			$option_name        = 'academy_course_' . $course_id . '_completed_topics';
			$saved_topics_lists = (array) json_decode( get_user_meta( get_current_user_id(), $option_name, true ), true );

			if ( $saved_topics_lists ) {
				foreach ( $saved_topics_lists as $index => $value ) {
					foreach ( $value as $id => $timestamp ) {
						if ( (int) $topic_id === (int) $id && $type === $index ) {
							return false;
						}

						$content_unavailable_date = $timestamp + ( $drip_content['schedule_by_topic_unlock_date'] * DAY_IN_SECONDS );

						if ( $content_unavailable_date < wp_date( 'U' ) ) {
							$message = __( 'This content has been expired on', 'academy-pro' ) . ' ' . gmdate( get_option( 'date_format' ), $content_unavailable_date );
							return array(
								'message' => $message,
								'type'    => $type,
							);
						}
					}
				}
			}
		} elseif ( 'schedule_by_enroll_date' === $drip_content_type && $drip_content['schedule_by_enroll_date'] ) {
			$enrolled    = \Academy\Helper::is_enrolled( $course_id, get_current_user_id() );
			$content_available_date = strtotime( "$enrolled->post_date +" . $drip_content['schedule_by_enroll_date'] . ' days' );
			if ( $content_available_date > wp_date( 'U' ) ) {
				$message = __( 'This content will be accessible on', 'academy-pro' ) . ' ' . gmdate( get_option( 'date_format' ), $content_available_date );
				return array(
					'message' => $message,
					'type' => $type
				);
			}
		} elseif ( 'schedule_by_sequentially' === $drip_content_type ) {
			if ( true !== Helper::is_complete_previous_topic( $course_id, $topic_id, $type ) ) {
				return array(
					'message' => __( 'You must complete the previous topic to proceed.', 'academy-pro' ),
					'type' => $type
				);
			}
		} elseif ( 'schedule_by_prerequisite' === $drip_content_type && count( $drip_content['schedule_by_prerequisite'] ) ) {
			$completed_topics_lists = (array) json_decode( get_user_meta( get_current_user_id(), 'academy_course_' . $course_id . '_completed_topics', true ), true );
			$have_to_complete = array();
			if ( is_array( $drip_content['schedule_by_prerequisite'] ) ) {
				foreach ( $drip_content['schedule_by_prerequisite'] as $prerequisite_item ) {
					$is_completed = ( isset( $completed_topics_lists[ $prerequisite_item['type'] ][ $prerequisite_item['value'] ] ) ? $completed_topics_lists[ $prerequisite_item['type'] ][ $prerequisite_item['value'] ] : '' );
					if ( ! $is_completed ) {
						$have_to_complete[] = $prerequisite_item;
					}
				}
			}

			if ( count( $have_to_complete ) ) {
				return array(
					'message' => __( 'To access this topic, finish the following prerequisites.', 'academy-pro' ),
					'type' => $type,
					'data' => $have_to_complete,
				);
			}
		}//end if
	}
}
