<?php
namespace AcademyProCourseBundle;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Assets {
	public static function init() {
		$self = new self();
		add_action( 'wp_enqueue_scripts', [ $self, 'frontend_scripts' ], 10 );
		add_filter( 'academy/is_common_pages', array( $self, 'add_common_scripts' ) );
	}

	public function frontend_scripts() {
		global $post;

		if ( $post && get_post_type( $post->ID ) === 'alms_course_bundle' ) {
			wp_enqueue_style(
				'academy-pro-course-bundle-common-styles',
				ACADEMY_PRO_ASSETS_URI . 'build/courseBundle.css',
				array(),
				filemtime( ACADEMY_ASSETS_DIR_PATH . 'build/frontendCommon.css' ),
				'all'
			);
		}
	}

	public function add_common_scripts( $flag ) {
		global $post;

		if ( $post && 'alms_course_bundle' === get_post_type( $post->ID ) ) {
			$flag = true;
		}

		return $flag;
	}
}
