<?php
namespace AcademyProCourseBundle;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Academy\Interfaces\AddonInterface;
use AcademyProCourseBundle\Assets;

final class CourseBundle implements AddonInterface {
	private $addon_name = 'course-bundle';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_PRO_COURSE_BUNDLE_VERSION', '1.0' );
		define( 'ACADEMY_PRO_COURSE_BUNDLE_DIR_PATH', ACADEMY_PRO_ADDONS_DIR_PATH . 'course-bundle/' );
	}
	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) || ( ! \Academy\Helper::is_active_woocommerce() && ! class_exists( \StoreEngine::class ) ) ) {
			return;
		}

		// Run Addon functionality
		$this->load_dependency();
		Database::init();
		Assets::init();
		Ajax::init();
		Integration::init();
		Frontend::init();
	}

	public function load_dependency() {
		require_once ACADEMY_PRO_COURSE_BUNDLE_DIR_PATH . 'functions.php';
		require_once ACADEMY_PRO_COURSE_BUNDLE_DIR_PATH . 'hooks.php';
	}

	public function addon_activation_hook() {
		// Flash role & rewrite
		update_option( 'academy_flash_role_management', true );
		update_option( 'academy_required_rewrite_flush', \Academy\Helper::get_time() );
	}
}
