<?php
namespace AcademyProCourseBundle;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class Database {


	public static function init() {
		$self = new self();
		add_action( 'init', [ $self, 'create_alms_course_bundle_post_type' ] );
		add_action( 'rest_api_init', [ $self, 'register_alms_course_bundle_meta' ] );
	}

	public function create_alms_course_bundle_post_type() {
		register_post_type(
			'alms_course_bundle',
			array(
				'labels'                => array(
					'name'                  => esc_html__( 'Course Bundle', 'academy-pro' ),
					'singular_name'         => esc_html__( 'Course Bundle', 'academy-pro' ),
					'search_items'          => esc_html__( 'Search Course Bundle', 'academy-pro' ),
					'parent_item_colon'     => esc_html__( 'Parent Course Bundle:', 'academy-pro' ),
					'not_found'             => esc_html__( 'No Course bundles found.', 'academy-pro' ),
					'not_found_in_trash'    => esc_html__( 'No Course bundles found in Trash.', 'academy-pro' ),
					'archives'              => esc_html__( 'Course bundle archives', 'academy-pro' ),
				),
				'public'                => true,
				'publicly_queryable'    => true,
				'show_ui'               => true,
				'show_in_menu'          => false,
				'show_in_admin_bar'     => false,
				'show_in_nav_menus'     => false,
				'hierarchical'          => true,
				'rewrite'               => array( 'slug' => 'course-bundle' ),
				'query_var'             => true,
				'has_archive'           => true,
				'delete_with_user'      => false,
				'supports'              => array( 'title', 'editor', 'thumbnail', 'custom-fields', 'comments', 'post-formats', 'author' ),
				'show_in_rest'          => true,
				'rest_base'             => 'alms_course_bundle',
				'rest_namespace'        => ACADEMY_PLUGIN_SLUG . '/v1',
				'rest_controller_class' => 'WP_REST_Posts_Controller',
				'capability_type'           => 'post',
				'capabilities'              => array(
					'edit_post'             => 'edit_academy_course_bundle',
					'read_post'             => 'read_academy_course_bundle',
					'delete_post'           => 'delete_academy_course_bundle',
					'delete_posts'          => 'delete_academy_course_bundles',
					'edit_posts'            => 'edit_academy_course_bundles',
					'edit_others_posts'     => 'edit_others_academy_course_bundles',
					'publish_posts'         => 'publish_academy_course_bundles',
					'read_private_posts'    => 'read_private_academy_course_bundles',
					'create_posts'          => 'edit_academy_course_bundles',
				),
			)
		);
	}

	public function register_alms_course_bundle_meta() {
		register_meta(
			'post',
			'academy_course_bundle_product_id',
			array(
				'object_subtype' => 'alms_course_bundle',
				'type'           => 'integer',
				'single'         => true,
				'show_in_rest'   => true,
			)
		);

		register_meta(
			'post',
			'academy_course_bundle_courses_ids', // need to change it academy_course_bundle_course_ids
			array(
				'object_subtype' => 'alms_course_bundle',
				'type'           => 'array',
				'single'         => true,
				'show_in_rest'   => [
					'schema' => array(
						'items' => array(
							'type'       => 'object',
							'properties' => [
								'label'   => array(
									'type' => 'string',
								),
								'value'   => array(
									'type' => 'integer',
								),
							],
						),
					),
				],
			)
		);

		register_meta(
			'post',
			'academy_course_bundle_discount_badge',
			array(
				'object_subtype' => 'alms_course_bundle',
				'type'           => 'string',
				'single'         => true,
				'show_in_rest'   => true,
			)
		);
	}
}
