<?php
namespace  AcademyProCourseBundle\Frontend;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Template {
	public static function init() {
		$self = new self();
		$self->dispatch_hook();
		Template\Loader::init();
	}

	public function dispatch_hook() {
		add_filter( 'academy/get_course_archive_post_types', array( $this, 'add_course_bundle_course_type' ) );
		add_filter( 'academy/course_archive_post_types', array( $this, 'add_bundle_course_type' ) );
		add_filter( 'academy/get_course_filter_types', array( $this, 'add_course_bundle_filter' ) );
		add_action( 'academy/get_course_archive_search_query_args', array( $this, 'add_course_bundle_search_args' ), 10, 2 );
	}

	public function add_course_bundle_course_type( $post_types ) {
		$post_types[] = 'alms_course_bundle';
		return $post_types;
	}

	public function add_bundle_course_type( $post_types ) {
		if ( ! \Academy\Helper::is_fse_theme() ) {
			$post_types[] = 'alms_course_bundle';
		}
		return $post_types;
	}

	public function add_course_bundle_filter( $types ) {
		$types['bundle'] = __( 'Bundle', 'academy-pro' );
		return $types;
	}

	public function add_course_bundle_search_args( $args, $data ) {
		if ( in_array( 'bundle', $data['type'], true ) ) {
			$args['post_type']  = 'alms_course_bundle';
			unset( $args['meta_query'] );
		}

		return $args;
	}
}
