<?php

if ( ! function_exists( 'academy_pro_course_bundle_single_header' ) ) {
	function academy_pro_course_bundle_single_header() {
		$difficulty_level = get_post_meta( get_the_ID(), 'academy_course_difficulty_level', true );
		$preview_video    = \Academy\Helper::get_course_preview_video( get_the_ID() );
		\Academy\Helper::get_template(
			'single-course/header.php',
			apply_filters(
				'academy/single_course_header_args',
				[
					'difficulty_level' => $difficulty_level,
					'preview_video'    => $preview_video,
				]
			)
		);
	}
}

if ( ! function_exists( 'academy_pro_course_bundle_single_enroll' ) ) {
	function academy_pro_course_bundle_single_enroll() {
		\AcademyPro\Helper::get_template(
			'course-bundle/enroll/enroll.php'
		);
	}
}

if ( ! function_exists( 'academy_pro_course_bundle_single_price' ) ) {
	function academy_pro_course_bundle_single_price() {
		// return if the monetize engine is not woocommerce
		if ( 'woocommerce' !== \Academy\Helper::monetization_engine() ) {
			return;
		}

		$bundle_id = get_the_ID();
		$enrolled  = \Academy\Helper::is_enrolled( $bundle_id, get_current_user_id() );
		$price     = '';
		$regular_price = '';
		$sale_price    = '';
		if ( \Academy\Helper::is_active_woocommerce() ) {
			$product_id = get_post_meta( $bundle_id, 'academy_course_bundle_product_id', true );

			if ( $product_id ) {
				$product = wc_get_product( $product_id );
				if ( $product ) {
					$price = $product->get_price_html();
					$regular_price = $product->get_regular_price();
					$sale_price    = $product->get_sale_price();
				}
			}
		}

		ob_start();

		\AcademyPro\Helper::get_template(
			'course-bundle/enroll/price.php',
			apply_filters(
				'academy_pro/single/bundle_price_args',
				array(
					'enrolled'       => $enrolled,
					'is_paid'        => true,
					'regular_price'  => $regular_price,
					'sale_price'     => $sale_price,
					'price'          => $price,
				),
				$bundle_id
			)
		);

        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo apply_filters( 'academy/templates/single_course/price_content', ob_get_clean(), $bundle_id );
	}
}//end if

if ( ! function_exists( 'academy_pro_course_bundle_single_enroll_content' ) ) {
	function academy_pro_course_bundle_single_enroll_content() {
		// return if the monetize engine is not woocommerce
		if ( 'woocommerce' !== \Academy\Helper::monetization_engine() ) {
			return;
		}

		$bundle_id = get_the_ID();
		$duration  = \AcademyProCourseBundle\Helper::get_bundle_duration( $bundle_id );
		$total_lessons  = \AcademyProCourseBundle\Helper::get_bundle_lessons( $bundle_id );
		$total_enrolled = \AcademyProCourseBundle\Helper::get_bundle_enrolled( $bundle_id );
		$max_students = \AcademyProCourseBundle\Helper::get_max_students( $bundle_id );
		$total_enroll_count_status = \Academy\Helper::get_settings( 'is_enabled_course_single_enroll_count', true );
		$last_update  = get_the_modified_time( get_option( 'date_format' ), $bundle_id );

		ob_start();

		\AcademyPro\Helper::get_template(
			'course-bundle/enroll/content.php',
			apply_filters(
				'academy_pro/single/bundle_content_args',
				array(
					'duration'       => $duration,
					'total_lessons'  => $total_lessons,
					'total_enroll_count_status' => $total_enroll_count_status,
					'total_enrolled' => $total_enrolled,
					'max_students'   => $max_students,
					'last_update'    => $last_update,
				),
				$bundle_id
			)
		);

        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo apply_filters( 'academy/templates/single_course/enroll_content', ob_get_clean(), $bundle_id );
	}
}//end if

if ( ! function_exists( 'academy_pro_course_bundle_discount_information' ) ) {
	function academy_pro_course_bundle_discount_information( $regular_price, $sale_price ) {
		if ( $regular_price && $sale_price ) {
			$discount_type = (string) get_post_meta( get_the_ID(), 'academy_course_bundle_discount_badge', true );
			$discount      = ( $regular_price - $sale_price );

			if ( 'percent' === $discount_type ) {
				$discount = number_format( ( ( $discount / $regular_price ) * 100 ), 2 );
			}

			\AcademyPro\Helper::get_template(
				'course-bundle/discount.php',
				apply_filters(
					'academy_pro/single/course_bundle_discount_info_args',
					array(
						'discount_type' => $discount_type,
						'discount'      => $discount
					)
				)
			);

		}//end if
	}
}//end if

if ( ! function_exists( 'academy_pro_course_bundle_single_sidebar' ) ) {
	function academy_pro_course_bundle_single_sidebar() {
		\AcademyPro\Helper::get_template( 'course-bundle/sidebar.php' );
	}
}

if ( ! function_exists( 'academy_pro_course_bundle_single_description' ) ) {
	function academy_pro_course_bundle_single_description() {
		\AcademyPro\Helper::get_template( 'course-bundle/description.php' );
	}
}

if ( ! function_exists( 'academy_pro_course_bundle_single_bundle_course_list' ) ) {
	function academy_pro_course_bundle_single_bundle_course_list() {
		\AcademyPro\Helper::get_template( 'course-bundle/courses.php' );
	}
}

if ( ! function_exists( 'academy_pro_course_bundle_single_enroll_wishlist_and_share' ) ) {
	function academy_pro_course_bundle_single_enroll_wishlist_and_share() {
		global $wpdb;
		$bundle_id              = get_the_ID();
		$user_id                = get_current_user_id();
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$is_already_in_wishlist = $wpdb->get_row( $wpdb->prepare( "SELECT * from {$wpdb->usermeta} WHERE user_id = %d AND meta_key = 'academy_course_wishlist' AND meta_value = %d;", $user_id, $bundle_id ) );
		$is_show_wishlist = (bool) \Academy\Helper::get_settings( 'is_enabled_course_wishlist', true );
		$is_show_course_share = (bool) \Academy\Helper::get_settings( 'is_enabled_course_share', true );
		if ( $is_show_wishlist || $is_show_course_share ) {
			\AcademyPro\Helper::get_template(
				'course-bundle/enroll/wishlist-and-share.php',
				apply_filters(
					'academy_pro/single/course_bundle_enroll_wishlist_and_share_args',
					[
						'is_already_in_wishlist'    => $is_already_in_wishlist,
						'is_show_wishlist'          => $is_show_wishlist,
						'is_show_course_share'      => $is_show_course_share,
					]
				)
			);
		}
	}
}//end if

if ( ! function_exists( 'academy_pro_course_bundle_single_course_count' ) ) {
	function academy_pro_course_bundle_single_course_count() {
		if ( 'alms_course_bundle' === get_post_type( get_the_ID() ) ) {
			$courses_count = count( (array) get_post_meta( get_the_ID(), 'academy_course_bundle_courses_ids', true ) );

			if ( ! $courses_count ) {
				return;
			}

			\AcademyPro\Helper::get_template(
				'course-bundle/bundle-badge.php',
				apply_filters(
					'academy/single/course_bundle_badge',
					[
						'courses_count' => $courses_count,
					]
				)
			);
		}
	}
}//end if

if ( ! function_exists( 'academy_pro_remove_bundle_ratings_and_price' ) ) {
	function academy_pro_remove_bundle_ratings_and_price() {
		if ( 'alms_course_bundle' === get_post_type( get_the_ID() ) ) {
			remove_action( 'academy/templates/course_loop_footer_inner', 'academy_course_loop_footer_inner_price', 11 );
			remove_action( 'academy/templates/course_loop_footer_inner', 'academy_course_loop_rating', 10 );
		} else {
			add_action( 'academy/templates/course_loop_footer_inner', 'academy_course_loop_footer_inner_price', 11 );
			add_action( 'academy/templates/course_loop_footer_inner', 'academy_course_loop_rating', 10 );
		}
	}
}

if ( ! function_exists( 'academy_pro_add_bundle_loop_price' ) ) {
	function academy_pro_add_bundle_loop_price() {
		if ( 'alms_course_bundle' !== get_post_type( get_the_ID() ) || 'woocommerce' !== \Academy\Helper::monetization_engine() ) {
			return;
		}

		$bundle_id = get_the_ID();
		$price     = '';
		if ( \Academy\Helper::is_active_woocommerce() ) {
			$product_id = AcademyProCourseBundle\Helper::get_bundle_product_id( $bundle_id );

			if ( $product_id ) {
				$product = wc_get_product( $product_id );
				if ( $product ) {
					$price = $product->get_price_html();
				}
			}
		}
		\AcademyPro\Helper::get_template(
			'course-bundle/loop/price.php',
			array(
				'price' => $price,
			)
		);
	}
}//end if

if ( ! function_exists( 'academy_pro_add_bundle_loop_enrollment_count' ) ) {
	function academy_pro_add_bundle_loop_enrollment_count() {
		$bundle_id = get_the_ID();
		if ( 'alms_course_bundle' === get_post_type( $bundle_id ) && 'woocommerce' === \Academy\Helper::monetization_engine() ) {
			$total_enrolled = \AcademyProCourseBundle\Helper::get_bundle_enrolled( $bundle_id );

			echo '<span><i class="academy-icon academy-icon--group-profile"></i> ' . esc_html( $total_enrolled ) . '</span>';
		}
	}
}

if ( ! function_exists( 'academy_pro_course_bundle_single_enroll_form' ) ) {
	function academy_pro_course_bundle_single_enroll_form( $bundle_id = null ) {
		global $post;
		$original_post = $post;
		if ( $bundle_id ) {
            // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			$GLOBALS['post'] = get_post( $bundle_id );
		}

		$engine = \Academy\Helper::get_settings( 'monetization_engine' );

		if ( 'alms_course_bundle' !== get_post_type( get_the_ID() ) || 'woocommerce' !== $engine ) {
			return;
		}

		$user_id    = get_current_user_id();
		$product_id = absint( get_post_meta( get_the_ID(), 'academy_course_bundle_product_id', true ) );
		$course_ids = (array) get_post_meta( get_the_ID(), 'academy_course_bundle_courses_ids', true );
		$course_ids = wp_list_pluck( $course_ids, 'value' );
		$enrollment = false;
		$enrollment = \AcademyProCourseBundle\Helper::get_order_by_customer_id_and_product_id( $user_id, $product_id );

		ob_start();

		if ( ( $enrollment && 'completed' === $enrollment->status ) ) {
			\AcademyPro\Helper::get_template( 'course-bundle/enroll/continue.php' );
		} elseif ( $enrollment && ( 'on-hold' === $enrollment->status || 'processing' === $enrollment->status ) ) {
			\AcademyPro\Helper::get_template( 'course-bundle/enroll/notice.php', array(
				'status' => $enrollment->status
			));
		} elseif ( \AcademyProCourseBundle\Helper::is_bundle_fully_booked( get_the_ID() ) ) {
			\AcademyPro\Helper::get_template( 'course-bundle/enroll/closed-enrollment.php' );
		} else {
			$product_id = get_post_meta( get_the_ID(), 'academy_course_bundle_product_id', true );
			$is_enabled_academy_login  = \Academy\Helper::get_settings( 'is_enabled_academy_login', true );
			$force_login_before_enroll = $is_enabled_academy_login && \Academy\Helper::get_settings( 'woo_force_login_before_enroll', true );

			\AcademyPro\Helper::get_template( 'course-bundle/enroll/add-to-cart-form.php', array(
				'product_id'                => $product_id,
				'force_login_before_enroll' => $force_login_before_enroll
			));
		}

        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo apply_filters( 'academy/templates/single_bundle/enroll_form', ob_get_clean(), get_the_ID() );

		if ( $bundle_id ) {
            // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			$GLOBALS['post'] = $original_post;
		}
	}
}//end if
