<?php
namespace AcademyProCoursePrerequisites;

use Academy;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Frontend {
	public static function init() {
		$self = new self();
		add_filter( 'academy/templates/single_course/enroll_form', array( $self, 'prerequisites_info' ), 10, 2 );
		add_filter( 'academy/templates/single_course/prerequisite_courses', array( $self, 'get_prerequisite_courses' ), 10, 2 );
	}
	public function prerequisites_info( $html, $course_id ) {
		$required_courses = Helper::get_prerequisite_ids( $html, $course_id );

		if ( $required_courses === $html ) {
			return $html;
		}
		ob_start();
		\AcademyPro\Helper::get_template('course-prerequisites/prerequisites.php', array(
			'required_courses' => $required_courses,
		) );
		return ob_get_clean();
	}

	public function get_prerequisite_courses( $status, $course_id ) {
		$type = Academy\Helper::get_course_type( $course_id );
		if ( \Academy\Helper::get_addon_active_status( 'course-prerequisites' ) && 'public' !== $type ) {
			$prerequisite_ids = Helper::get_prerequisite_ids( array(), $course_id );
		}
		return $prerequisite_ids ?? false;
	}
}
