jQuery(document).ready(function($) {
    $(document).on('click', '#device-reset', function() {
        $.ajax({
            url: academy_pro_device_login_restrictions.ajax_url,
            type: 'POST',
            data: {
                action: 'academy_pro_device_login_restrictions/remove_all_active_sessions',
                security: academy_pro_device_login_restrictions.nonce,
            },
            beforeSend: function() {
                $('#device-reset').text('Resetting...').prop('disabled', true);
            },
            success: function(response) {
                var messageClass = response.success ? 'success' : 'error';
                var notification = $('<div class="academy-pro-notification ' + messageClass + '">' + response.data + '</div>');

                $('body').prepend(notification);
                setTimeout(() => notification.fadeOut(500, function() { $(this).remove(); }), 3000);

                if (response.success) {
                    setTimeout(() => location.reload(), 500);
                }
            }
        });
    });
});
