<?php
namespace AcademyProDeviceLoginRestrictions;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Academy\Interfaces\AddonInterface;

final class DeviceLoginRestrictions implements AddonInterface {
	private $addon_name = 'device-login-restrictions';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_PRO_DEVICE_LOGIN_RESTRICTIONS_VERSION', '1.0' );
		define( 'ACADEMY_PRO_DEVICE_LOGIN_RESTRICTIONS_DIR_PATH', ACADEMY_PRO_ADDONS_DIR_PATH . 'device-login-restrictions/' );
	}
	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}
		$this->load_dependencies();
		// Run Addon functionality
		Admin::init();
		Assets::init();
	}

	public function load_dependencies() {
		require_once ACADEMY_PRO_DEVICE_LOGIN_RESTRICTIONS_DIR_PATH . 'frontend/functions.php';
		require_once ACADEMY_PRO_DEVICE_LOGIN_RESTRICTIONS_DIR_PATH . 'frontend/hooks.php';
	}

	public function addon_activation_hook() {
	}
}
