<?php
namespace AcademyProEmail;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Ajax {
	public static function init() {
		$self = new self();
		add_action( 'wp_ajax_academy_pro_email/get_email_settings', array( $self, 'get_email_settings' ) );
		add_action( 'wp_ajax_academy_pro_email/save_email_settings', array( $self, 'save_email_settings' ) );
		// Test Email
		add_action( 'wp_ajax_academy_pro_email/preview_template', array( $self, 'preview_template' ) );
		add_action( 'wp_ajax_academy_pro_email/test_email', array( $self, 'test_email' ) );
	}
	public function get_email_settings() {
		check_ajax_referer( 'academy_nonce', 'security' );
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die();
		}
		$settings = Admin\Settings::get_settings_saved_data();
		wp_send_json_success( $settings );
	}

	public function save_email_settings() {
		check_ajax_referer( 'academy_nonce', 'security' );
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die();
		}
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$form_name = isset( $_POST['form_name'] ) ? sanitize_text_field( wp_unslash( $_POST['form_name'] ) ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$email_address = isset( $_POST['email_address'] ) ? sanitize_email( wp_unslash( $_POST['email_address'] ) ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$email_content_type = isset( $_POST['email_content_type'] ) ? sanitize_text_field( wp_unslash( $_POST['email_content_type'] ) ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$header_image = isset( $_POST['header_image'] ) ? sanitize_text_field( wp_unslash( $_POST['header_image'] ) ) : '';
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$footer_text = wp_kses_post( wp_unslash( $_POST['footer_text'] ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$enrolled_course = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['enrolled_course'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$finished_course = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['finished_course'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$tutor_booked = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['tutor_booked'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$become_an_instructor = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['become_an_instructor'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$student_registration = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['student_registration'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$email_verify = Helper::sanitize_email_template_item( json_decode( wp_unslash( $_POST['email_verify'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$assignment_submit = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['assignment_submit'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$assignment_evaluate = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['assignment_evaluate'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$quiz_submit = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['quiz_submit'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$quiz_evaluate = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['quiz_evaluate'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$withdraw_request_approved = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['withdraw_request_approved'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$withdraw_request_rejected = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['withdraw_request_rejected'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$question_submit = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['question_submit'] ), true ) );
		// phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		$question_reply = Helper::sanitize_email_template_data( json_decode( wp_unslash( $_POST['question_reply'] ), true ) );

		$is_saved = Admin\Settings::save_settings(array(
			'form_name' => $form_name,
			'email_address' => $email_address,
			'email_content_type' => $email_content_type,
			'header_image'  => $header_image,
			'footer_text'  => $footer_text,
			'enrolled_course'  => $enrolled_course,
			'finished_course' => $finished_course,
			'tutor_booked' => $tutor_booked,
			'become_an_instructor' => $become_an_instructor,
			'student_registration' => $student_registration,
			'email_verify' => $email_verify,
			'assignment_submit' => $assignment_submit,
			'assignment_evaluate' => $assignment_evaluate,
			'quiz_submit' => $quiz_submit,
			'quiz_evaluate' => $quiz_evaluate,
			'withdraw_request_approved' => $withdraw_request_approved,
			'withdraw_request_rejected' => $withdraw_request_rejected,
			'question_submit' => $question_submit,
			'question_reply' => $question_reply,
		));

		if ( $is_saved ) {
			$saved_data = Admin\Settings::get_settings_saved_data();
			wp_send_json_success( $saved_data );
		}
		wp_send_json_error( __( 'Something went wrong!!', 'academy-pro' ) );
	}

	public function test_email() {
		check_ajax_referer( 'academy_nonce', 'security' );
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die();
		}

		$templateName = isset( $_POST['templateName'] ) ? sanitize_text_field( wp_unslash( $_POST['templateName'] ) ) : '';
		$templateSubName = isset( $_POST['templateSubName'] ) ? sanitize_text_field( wp_unslash( $_POST['templateSubName'] ) ) : '';
		$settings = Admin\Settings::get_settings_saved_data();
		$footer = $settings['footer_text'];
		$email_type = $settings['email_content_type'];
		$settings = ( ! empty( $templateSubName ) ? $settings[ $templateName ][ $templateSubName ] : $settings[ $templateName ] );
		$is_enable = (bool) $settings['is_enable'];
		if ( ! $is_enable ) {
			wp_send_json_error( ucfirst( $templateSubName ) . ' ' . __( 'Mail Settings is disable. Please Enable it and try again.', 'academy-pro' ) );
		}

		$to = get_option( 'admin_email' );

		$site_url    = get_bloginfo( 'url' );
		$site_name   = get_bloginfo( 'name' );

		$subject = str_replace(
			[ '{user_display_name}', '{site_title}', '{site_url}' ],
			[ 'Test Display Name', $site_name, $site_url ],
			$settings['email_subject']
		);

		$templateName = Helper::get_email_template_name( $templateName, $templateSubName );

		if ( 'plainText' === $email_type ) {
			$headers = array( 'Content-Type: text/plain; charset=UTF-8' );
			$body = strip_tags( $settings['email_heading'], '<br>' ) . "\n" . strip_tags( $settings['email_content'], '<br>' ) . "\n" . strip_tags( $footer, '<br>' );
		} else {
			$headers = array( 'Content-Type: text/html; charset=UTF-8' );
			ob_start();
			\AcademyPro\Helper::get_template('email/' . $templateName, array(
				'heading' => $settings['email_heading'],
				'content' => $settings['email_content'],
				'footer' => $footer,
			));
			$body = ob_get_clean();
		}
		$body = str_replace(
			[
				'{user_display_name}',
				'{user_email}',
				'{course_name}',
				'{tutor_name}',
				'{course_url}',
				'{student_profile}',
				'{instructor_dashboard}',
				'{site_title}',
				'{request_email}',
				'{admin_instructor_manager}',
				'{login_url}',
				'{email_address}',
				'{site_url}',
				'{verify_email_link}'
			],
			[
				'Test Display Name',
				'test@admin.com',
				'Simple Course Name',
				'Simple Tutor Name',
				$site_url,
				$site_url,
				\Academy\Helper::get_page_permalink( 'frontend_dashboard_page' ),
				$site_name,
				'example@instructor.com',
				esc_url( admin_url( 'admin.php?page=academy-instructors' ) ),
				esc_url( wp_login_url() ),
				'test@admin.com',
				$site_url,
				add_query_arg( array(
					'email' => 'test@admin.com',
					'token' => 'test_token',
					'nonce'  => wp_create_nonce( 'academy_email_verification_test@admin.com' )
				), \Academy\Helper::get_page_permalink( 'frontend_dashboard_page' ) )
			],
			$body
		);

		$mail = new Email\Mail();
		$is_send = $mail->send_mail( $to, $subject, $body, $headers );

		if ( $is_send ) {
			wp_send_json_success( ucfirst( $templateSubName ) . ' ' . __( 'Test Mail Send Successfully.', 'academy-pro' ) );

		}
		wp_send_json_error( ucfirst( $templateSubName ) . ' ' . __( 'Test Mail Send Failed.', 'academy-pro' ) );
	}

	public function preview_template() {
		check_ajax_referer( 'academy_nonce', 'security' );
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die();
		}
		$templateName = isset( $_POST['templateName'] ) ? sanitize_text_field( wp_unslash( $_POST['templateName'] ) ) : '';
		$templateSubName = isset( $_POST['templateSubName'] ) ? sanitize_text_field( wp_unslash( $_POST['templateSubName'] ) ) : '';

		$settings = Admin\Settings::get_settings_saved_data();
		$footer = $settings['footer_text'];
		$settings = $templateSubName ? $settings[ $templateName ][ $templateSubName ] : $settings[ $templateName ];

		$templateName = Helper::get_email_template_name( $templateName, $templateSubName );
		ob_start();
		\AcademyPro\Helper::get_template('email/' . $templateName, array(
			'heading' => $settings['email_heading'],
			'content' => $settings['email_content'],
			'footer'  => $footer,
		));
		$preview = ob_get_clean();
		wp_send_json_success( $preview );
	}
}
