<?php
namespace AcademyProEmail;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Academy\Interfaces\AddonInterface;

final class Email implements AddonInterface {
	private $addon_name = 'email';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_PRO_EMAIL_VERSION', '1.0' );
		define( 'ACADEMY_PRO_EMAIL_VERSION_NAME', 'academy_pro_email_version' );
		define( 'ACADEMY_PRO_EMAIL_SETTINGS_NAME', 'academy_pro_email_settings' );
	}
	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		// Run Addon functionality
		Ajax::init();
		Hooks::init();
		$this->run_migration();
	}

	public function addon_activation_hook() {
		Admin\Settings::save_settings();
	}

	public function run_migration() {
		if ( delete_option( 'academy_pro_run_email_migration_2_7_0' ) ) {
			$Settings = new Admin\Settings();
			$default_data = $Settings::get_settings_default_data();
			$settings_data = $Settings::get_settings_saved_data();
			if ( empty( $saved_data['withdraw_request_approved']['instructor'] ) ) {
				$settings_data['withdraw_request_approved']['instructor'] = $default_data['withdraw_request_approved']['instructor'];
			}
			if ( empty( $saved_data['withdraw_request_rejected']['instructor'] ) ) {
				$settings_data['withdraw_request_rejected']['instructor'] = $default_data['withdraw_request_rejected']['instructor'];
			}
			update_option( ACADEMY_PRO_EMAIL_SETTINGS_NAME, wp_json_encode( $settings_data ), false );
		}

		if ( delete_option( 'academy_pro_run_email_migration' ) ) {
			$Settings = new Admin\Settings();
			$default_data = $Settings::get_settings_default_data();
			$settings_data = $Settings::get_settings_saved_data();
			if ( empty( $saved_data['question_submit']['admin'] ) ) {
				$settings_data['question_submit']['admin'] = $default_data['question_submit']['admin'];
			}
			if ( empty( $saved_data['question_submit']['instructor'] ) ) {
				$settings_data['question_submit']['instructor'] = $default_data['question_submit']['instructor'];
			}
			if ( empty( $saved_data['question_reply']['student'] ) ) {
				$settings_data['question_reply']['student'] = $default_data['question_reply']['student'];
			}
			update_option( ACADEMY_PRO_EMAIL_SETTINGS_NAME, wp_json_encode( $settings_data ), false );
		}

		if ( delete_option( 'academy_pro_run_email_migration_2_9_0' ) ) {
			$Settings = new Admin\Settings();
			$default_data = $Settings::get_settings_default_data();
			$settings_data = $Settings::get_settings_saved_data();
			if ( empty( $saved_data['tutor_booked']['admin'] ) ) {
				$settings_data['tutor_booked']['admin'] = $default_data['tutor_booked']['admin'];
			}
			if ( empty( $saved_data['tutor_booked']['instructor'] ) ) {
				$settings_data['tutor_booked']['instructor'] = $default_data['tutor_booked']['instructor'];
			}
			if ( empty( $saved_data['tutor_booked']['student'] ) ) {
				$settings_data['tutor_booked']['student'] = $default_data['tutor_booked']['student'];
			}
			update_option( ACADEMY_PRO_EMAIL_SETTINGS_NAME, wp_json_encode( $settings_data ), false );
		}
	}
}
