<?php
namespace AcademyProFluentCommunity\Feeds;

use AcademyProFluentCommunity\Classes\TrackCurriculumChanges;
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
class QuestionFeed extends Abstracts\EventFeed {
	public function init(): void {
		add_action(
			'academy/frontend/insert_course_qa',
			[ $this, 'notify' ],
			10, 1
		);
	}
	public function notify( array $question ): void {

		if (
			empty( $question ) ||
			empty( $question['_post'] ?? '' ) ||
			empty( $question['author'] ?? '' ) ||
			empty( $question['content'] ?? '' ) ||
			empty( $question['post'] ?? '' )
		) {
			return;
		}

		$course_permalink = $question['_post']['permalink'];
		$course_title = $question['_post']['title'];

		$this->course_id = $question['post'] ?? 0;

		$this->title     = sprintf( __( 'New Question asked by', 'academy-pro' ) . ' %s', esc_html( $question['author_name'] ) );
		$this->message   = sprintf(
			'<h3><a href="%s">' . __( 'A question has been posted by', 'academy-pro' ) . ' %s @%s </a></h3>
            <blockquote>%s</blockquote>',
			esc_url( $course_permalink ),
			esc_html( $question['author_name'] ),
			esc_html( $course_title ),
			esc_html( $question['content']['rendered'] )
		);
		$this->event     = 'user_question';
		$this->push();

	}
}
