<?php

namespace AcademyProFluentCRM;

use FluentCampaign\App\Services\BaseAdvancedReport;
use FluentCampaign\App\Services\Commerce\Commerce;
use FluentCampaign\App\Services\Commerce\ContactRelationItemsModel;
use FluentCrm\App\Services\ReportingHelperTrait;
use FluentCrm\Framework\Support\Arr;

class AdvancedReport extends BaseAdvancedReport {

	use ReportingHelperTrait;

	public function __construct() {
		 $this->provider = 'academylms'; //phpcs:ignore
	}

	/**
	 * @param array $filters
	 * @return array
	 */
	public function getReports( $filters = [] ): array {
		$enabled = Commerce::isEnabled( $this->provider );

		if ( $enabled && Arr::get( $filters, 'top_products_only' ) ) {
			return [
				'top_products' => $this->getTopProductsByPost( $filters )
			];
		}

		$supports = [
			'product_growth'   => [
				'title'       => __( 'Enrollments', 'academy-pro' ),
				'has_product' => true,
				'sub_types' => [
					'all' => [
						'label' => __( 'All', 'academy-pro' )
					],
					'course' => [
						'label' => __( 'Courses', 'academy-pro' )
					]
				]
			],
			'customers_growth' => [
				'title' => __( 'Students Growth', 'academy-pro' )
			]
		];

		$overview = [
			'enabled'       => $enabled,
			'title'         => __( 'AcademyLMS - Advanced Reports', 'academy-pro' ),
			'supports'      => $supports,
			'has_top_products_filter' => true
		];

		if ( ! $enabled ) {
			$overview['enable_instruction'] = __( 'Please enable data sync first from FluentCRM', 'academy-pro' ) . ' <b><a href="' . admin_url( 'admin.php?page=fluentcrm-admin#/settings/integration_settings?selected_integration=AcademyLMS' ) . '">' . __( 'Settings -> Integrations Settings -> AcademyLMS', 'academy-pro' ) . '</a></b> ' . __( 'to view in details AcademyLMS reports', 'academy-pro' );
		} else {
			$overview['widgets'] = [
				'total_students'         => [
					'value'    => fluentCrmDb()->table( 'fc_contact_relations' )->where( 'provider', $this->provider )->count(),
					'label'    => __( 'Total Students', 'academy-pro' ),
					'is_int' => true
				],
				'total_enrollments'       => [
					'value' => ContactRelationItemsModel::provider( $this->provider )->where( 'item_type', 'course' )->count(),
					'label' => __( 'Total Course Enrollments', 'academy-pro' ),
					'is_int' => true
				]
			];
		}

		if ( in_array( 'top_products', Arr::get( $filters, 'with', [] ), true ) && $enabled ) {
			$overview['top_products'] = $this->getTopProductsByPost();
		}

		return $overview;
	}

	/**
	 * @param string $type
	 * @param array  $filters
	 * @return array|void
	 */
	public function getReport( $type, $filters = [] ) {
		if ( 'product_growth' === $type ) {

			$subType = Arr::get( $filters, 'sub_type', 'all' );

			if ( 'courses' === $subType ) {
				$filters['sub_type'] = 'by_item_types';
				$filters['item_types'] = [ 'course' ];
			}

			return $this->getProductGrowthCounts( $filters );
		} elseif ( 'customers_growth' === $type ) {
			return $this->getCustomersGrowth( $filters );
		}
	}
}
