<?php

namespace AcademyProFluentCRM;

use Academy\Traits\Courses;
use FluentCrm\App\Services\Funnel\FunnelHelper;

class Helper {

	public static function get_courses(): array {
		$courses = get_posts(array(
			'post_type' => 'academy_courses',
			'numberposts' => -1
		));

		$formattedCourses = [];
		foreach ( $courses as $course ) {
			$formattedCourses[] = [
				'id' => strval( $course->ID ),
				'title' => $course->post_title
			];
		}

		return $formattedCourses;
	}

	public static function get_lessons(): array {

		global $wpdb;
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$lessons = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}academy_lessons" );

		$formattedLessons = [];

		foreach ( $lessons as $lesson ) {
			$formattedLessons[] = [
				'id' => strval( $lesson->ID ),
				'title' => $lesson->lesson_title
			];
		}

		return $formattedLessons;
	}

	public static function is_in_courses( $courseIds, $subscriber ): bool {
		if ( ! $courseIds ) {
			return false;
		}

		$userId = $subscriber->getWpUserId();
		if ( ! $userId ) {
			return false;
		}

		// using fluentcrm ORM for faster development
		$course = fluentCrmDb()->table( 'posts' )
			->where( 'post_type', 'academy_enrolled' )
			->whereIn( 'post_parent', $courseIds )
			->where( 'post_author', $userId )
			->first();

		if ( $course ) {
			return true;
		}

		return false;
	}

	public static function get_user_courses( $userId ): array {
		$courses = fluentCrmDb()->table( 'posts' )
			->select( [ 'post_parent' ] )
			->where( 'post_type', 'academy_enrolled' )
			->where( 'post_author', $userId )
			->get();

		$courseIds = [];
		foreach ( $courses as $course ) {
			$courseIds[] = $course->post_parent;
		}

		return $courseIds;
	}

	public static function get_percentage_of_completed_topics_by_student_and_course_id( $student_id, $course_id ) {
		$course_curriculums = \Academy\Helper::get_course_curriculums_number_of_counts( $course_id );
		$total_completed_topics = \Academy\Helper::get_total_number_of_completed_course_topics_by_course_and_student_id( $course_id, $student_id );

		return \Academy\Helper::calculate_percentage( $course_curriculums['total_topics'], $total_completed_topics );
	}

	public static function get_trigger_source( $triggerName ) {
		$maps = [
			'academy_course_complete_after' => 'course',
			'academy/admin/course_complete_after' => 'course'
		];

		return isset( $maps[ $triggerName ] ) ? $maps[ $triggerName ] : false;

	}

	public static function create_contact_from_academy( $userId, array $tags = [] ) {
		$subscriberData = FunnelHelper::prepareUserData( $userId );
		if ( empty( $subscriberData['email'] ) ) {
			return false;
		}

		$subscriber = FunnelHelper::getSubscriber( $subscriberData['email'] );

		if ( ! $subscriber ) {
			$subscriberData['source'] = __( 'AcademyLMS', 'academy-pro' );
			$subscriber = FunnelHelper::createOrUpdateContact( $subscriberData );
		}

		if ( ! $subscriber ) {
			return false;
		}

		if ( $tags ) {
			$subscriber->attachTags( $tags );
		}

		return $subscriber;
	}

	public static function is_courses_completed( $courseIds, $subscriber ): bool {
		if ( ! $courseIds ) {
			return false;
		}

		$userId = $subscriber->getWpUserId();
		if ( ! $userId ) {
			return false;
		}

		foreach ( $courseIds as $courseId ) {
			if ( Courses::is_completed_course( $courseId, $userId ) ) {
				return true;
			}
		}

		return false;
	}

}
