<?php
namespace AcademyProGamipress\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Settings {
	public static function get_saved_data() {
		$settings = get_option( ACADEMY_PRO_GAMIPRESS_SETTINGS_NAME );
		if ( $settings ) {
			return json_decode( $settings, true );
		}
		return [];
	}
	public static function get_default_data() {
		return apply_filters('academy_pro_gmaipress/settings_default_data', [
			'points' => [],
			'achievements' => [],
			'ranks' => [],
		]);
	}

	public static function save_settings( $form_data = false ) {
		$default_data = self::get_default_data();
		$saved_data = self::get_saved_data();
		$settings_data = wp_parse_args( $saved_data, $default_data );
		if ( $form_data ) {
			$settings_data = wp_parse_args( $form_data, $settings_data );
		}
		// if settings already saved, then update it
		if ( count( $saved_data ) ) {
			return update_option( ACADEMY_PRO_GAMIPRESS_SETTINGS_NAME, wp_json_encode( $settings_data ) );
		}
		return add_option( ACADEMY_PRO_GAMIPRESS_SETTINGS_NAME, wp_json_encode( $settings_data ) );
	}
}
