<?php
namespace AcademyProGamipress\Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Classes\AbstractAjaxHandler;
use  AcademyProGamipress\Admin\Settings as GamipressSettings;
use Academy\Classes\Sanitizer;

class Settings extends AbstractAjaxHandler {
	protected $namespace = 'academy_pro_gamipress';
	public function __construct() {
		$this->actions = array(
			'update_settings' => array(
				'callback' => array( $this, 'update_settings' ),
			),
		);
	}

	public function update_settings( $payload_data ) {
		$points = isset( $payload_data['points'] ) ? json_decode( $payload_data['points'], true ) : '';
		$achievements = isset( $payload_data['achievements'] ) ? json_decode( $payload_data['achievements'], true ) : '';
		$ranks = isset( $payload_data['ranks'] ) ? json_decode( $payload_data['ranks'], true ) : '';
		$settings = GamipressSettings::get_default_data();
		if ( is_array( $points ) ) {
			$placements = [];
			foreach ( $points as $point ) {
				$placements[] = Sanitizer::sanitize_payload([
					'type'       => 'string',
					'page'     => 'string',
					'location'     => 'string',
				], $point);
			}
			$settings['points'] = $placements;
		}

		if ( is_array( $achievements ) ) {
			$placements = [];
			foreach ( $achievements as $achievement ) {
				$placements[] = Sanitizer::sanitize_payload([
					'type'       => 'string',
					'page'     => 'string',
					'location'     => 'string',
				], $achievement);
			}
			$settings['achievements'] = $placements;
		}

		if ( is_array( $ranks ) ) {
			$placements = [];
			foreach ( $ranks as $rank ) {
				$placements[] = Sanitizer::sanitize_payload([
					'type'       => 'string',
					'page'     => 'string',
					'location'     => 'string',
				], $rank);
			}
			$settings['ranks'] = $placements;
		}

		$is_update = GamipressSettings::save_settings( $settings );
		do_action( 'academy_pro/admin/after_save_settings', $is_update, 'gamipress', $_POST ); // phpcs:ignore WordPress.Security.NonceVerification.Missing
		wp_send_json_success( $is_update );
	}
}
