<?php

namespace AcademyProGamipress;

class Helper {
	public static function is_gamipess_active() {
		return in_array( 'gamipress/gamipress.php', get_option( 'active_plugins', array() ), true );
	}

	public static function get_reward_types_by_reward_name( $name ) : array {
		$types = array();
		switch ( $name ) {
			case 'points':
				$types = gamipress_get_points_types();
				break;
			case 'achievements':
				$types = gamipress_get_achievement_types();
				break;
			case 'ranks':
				$types = gamipress_get_rank_types();
				break;
		}

		$modified_types = array();
		foreach ( $types as $key => $type ) {
			$modified_types[] = array(
				'label' => $type['plural_name'],
				'value' => $key,
			);
		}

		return $modified_types;
	}

	public static function redner_gamipress_shortcode_for_given_location( $location ) {
		$gamipress_settings = \AcademyProGamipress\Admin\Settings::get_saved_data();
		$shortcodeMapping = [
			'points' => 'gamipress_user_points',
			'achievements' => 'gamipress_achievements',
			'ranks' => 'gamipress_user_rank'
		];

		foreach ( $gamipress_settings as $key => $rewards ) {
			if ( array_key_exists( $key, $shortcodeMapping ) ) {
				foreach ( $rewards as $reward ) {
					if ( $reward['location'] === $location ) {
						// In the future, we will create a new template to handle shortcode design or will create our custom design
						if ( 'achievements' !== $key ) {
							echo do_shortcode( '[' . $shortcodeMapping[ $key ] . ' type="' . $reward['type'] . '"]' );
						} else {
							echo do_shortcode( '[' . $shortcodeMapping[ $key ] . ' user_id="' . get_current_user_id() . '"]' );
						}
					}
				}
			}
		}
	}
}
