<?php

namespace AcademyProGamipress;

use AcademyProGamipress\Admin\Settings;

class Hooks {
	public static function init() {
		$self = new self();
		// For Settings add to universal
		add_filter( 'academy/api/settings/get_settings', array( $self, 'add_settings' ) );

		// For Quiz
		add_action( 'academy_quizzes/after_insert_quiz_status_completed', array( $self, 'add_quiz_completed_hooks' ), 10, 3 );
		add_action( 'academy_quizzes/after_insert_quiz_status_pass', array( $self, 'add_quiz_pass_hooks' ), 10, 3 );
		add_action( 'academy_quizzes/after_insert_quiz_status_failed', array( $self, 'add_quiz_fail_hooks' ), 10, 3 );

		// For Assignment
		add_action( 'academy_pro_assignment/after_submit_assignment', array( $self, 'add_assignments_completed_hooks' ), 10, 3 );
		add_action( 'academy_pro_assignment/after_evaluate_status_pass', array( $self, 'add_assignments_pass_hooks' ), 10, 3 );
		add_action( 'academy_pro_assignment/after_evaluate_status_fail', array( $self, 'add_assignments_fail_hooks' ), 10, 3 );

		// For courses
		add_action( 'academy/course/after_enroll', array( $self, 'add_enroll_courses_hooks' ), 10, 3 );
		add_action( 'academy/admin/course_complete_after', array( $self, 'add_complete_courses_hooks' ), 10, 2 );

		// Hook for frontend dashboard UI
		add_action( 'academy/templates/frontend_dashboard/after_analytics_card_item', array( $self, 'after_analytics_card_item' ) );
		add_action( 'academy/templates/frontend_dashboard/after_analytics_cards', array( $self, 'after_analytics_cards' ) );
		add_action( 'academy/templates/frontend_dashboard/after_user_email_popover', array( $self, 'after_user_email_popover' ) );
		add_action( 'academy/templates/frontend_dashboard/user_popover_menu_item_before_profile_menu', array( $self, 'user_popover_menu_item_before_profile_menu' ) );
	}

	public function after_analytics_card_item() {
		\AcademyProGamipress\Helper::redner_gamipress_shortcode_for_given_location( 'dashboard_card' );
	}

	public function after_analytics_cards() {
		\AcademyProGamipress\Helper::redner_gamipress_shortcode_for_given_location( 'dashboard_new_section' );
	}

	public function after_user_email_popover() {
		\AcademyProGamipress\Helper::redner_gamipress_shortcode_for_given_location( 'below_username' );
	}

	public function user_popover_menu_item_before_profile_menu() {
		\AcademyProGamipress\Helper::redner_gamipress_shortcode_for_given_location( 'below_author_section' );
	}

	public function add_complete_courses_hooks( $course_id, $user_id ) {
		do_action( 'academy_pro_gamipress_complete_course', $course_id, $user_id );
	}

	public function add_enroll_courses_hooks( $course_id, $enroll_id, $user_id ) {
		do_action( 'academy_pro_gamipress_enroll_course', $course_id, $user_id, $enroll_id );
		do_action( 'academy_pro_gamipress_enroll_specific_course', $user_id, $course_id, $enroll_id );
	}

	public function add_quiz_completed_hooks( $quiz_id, $user_id, $course_id ) {
		do_action( 'academy_pro_gamipress_complete_quiz', $quiz_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_complete_specific_quiz', $quiz_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_complete_quiz_specific_course', $quiz_id, $user_id, $course_id );
	}

	public function add_quiz_pass_hooks( $quiz_id, $user_id, $course_id ) {
		do_action( 'academy_pro_gamipress_pass_quiz', $quiz_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_pass_specific_quiz', $quiz_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_pass_quiz_specific_course', $quiz_id, $user_id, $course_id );
	}

	public function add_quiz_fail_hooks( $quiz_id, $user_id, $course_id ) {
		do_action( 'academy_pro_gamipress_fail_quiz', $quiz_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_fail_specific_quiz', $quiz_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_fail_quiz_specific_course', $quiz_id, $user_id, $course_id );
	}

	public function add_assignments_completed_hooks( $assignment_id, $user_id, $course_id ) {
		do_action( 'academy_pro_gamipress_complete_assignemnt', $assignment_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_complete_specific_assignment', $assignment_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_complete_assignment_specific_course', $assignment_id, $user_id, $course_id );
	}

	public function add_assignments_pass_hooks( $assignment_id, $user_id, $course_id ) {
		do_action( 'academy_pro_gamipress_pass_assignment', $assignment_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_pass_specific_assignment', $assignment_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_pass_assignment_specific_course', $assignment_id, $user_id, $course_id );
	}

	public function add_assignments_fail_hooks( $assignment_id, $user_id, $course_id ) {
		do_action( 'academy_pro_gamipress_fail_assignment', $assignment_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_fail_specific_assignment', $assignment_id, $user_id, $course_id );
		do_action( 'academy_pro_gamipress_fail_assignment_specific_course', $assignment_id, $user_id, $course_id );
	}

	public function add_settings( $settings ) {
		if ( ! isset( $settings['gamipress'] ) ) {
			$settings['gamipress'] = Settings::get_saved_data();
		}
		return $settings;
	}
}
