<?php

namespace AcademyProGamipress\Integrations;

class Triggers {
	public static function init() {
		$self = new self();

		// for all triggers
		add_filter( 'gamipress_activity_triggers', array( $self, 'add_gamipress_triggers' ) );

		// for specific triggers
		add_filter( 'gamipress_specific_activity_trigger_label', array( $self, 'add_label_to_specific_activity_trigger' ) );
		add_filter( 'gamipress_specific_activity_triggers', array( $self, 'add_gamipress_specific_activity_triggers' ) );

		add_filter( 'gamipress_specific_trigger_get_id', array( $self, 'get_specific_trigger_id' ), 10, 3 );
		add_filter( 'gamipress_trigger_get_user_id', array( $self, 'get_and_modify_user_id_for_trigger' ), 10, 3 );
		add_filter( 'gamipress_log_event_trigger_meta_data', array( $self, 'get_and_modify_log_event_trigger_meta_data' ), 10, 5 );
	}

	public function add_gamipress_triggers( $triggers ) {
		$triggers[ __( 'Academy LMS', 'academy-pro' ) ] = array(
			// Quiz triggers
			'academy_pro_gamipress_complete_quiz' => __( 'Complete a quiz', 'academy-pro' ),
			'academy_pro_gamipress_complete_specific_quiz' => __( 'Complete a specific quiz', 'academy-pro' ),
			'academy_pro_gamipress_complete_quiz_specific_course' => __( 'Complete a quiz in a specific course', 'academy-pro' ),
			'academy_pro_gamipress_pass_quiz' => __( 'Pass a quiz', 'academy-pro' ),
			'academy_pro_gamipress_pass_specific_quiz' => __( 'Pass a specific quiz', 'academy-pro' ),
			'academy_pro_gamipress_pass_quiz_specific_course' => __( 'Pass a quiz in a specific course', 'academy-pro' ),
			'academy_pro_gamipress_fail_quiz' => __( 'Fail a quiz', 'academy-pro' ),
			'academy_pro_gamipress_fail_specific_quiz' => __( 'Fail a specific quiz', 'academy-pro' ),
			'academy_pro_gamipress_fail_quiz_specific_course' => __( 'Fail a quiz in a specific course', 'academy-pro' ),

			// Assignments Triggers
			'academy_pro_gamipress_complete_assignemnt' => __( 'Complete an assignment', 'academy-pro' ),
			'academy_pro_gamipress_complete_specific_assignment' => __( 'Complete a specific assignment', 'academy-pro' ),
			'academy_pro_gamipress_complete_assignment_specific_course' => __( 'Complete an assignment in a specific course', 'academy-pro' ),
			'academy_pro_gamipress_pass_assignment' => __( 'Pass an assignment', 'academy-pro' ),
			'academy_pro_gamipress_pass_specific_assignment' => __( 'Pass a specific assignment', 'academy-pro' ),
			'academy_pro_gamipress_pass_assignment_specific_course' => __( 'Pass an assignment in a specific course', 'academy-pro' ),
			'academy_pro_gamipress_fail_assignment' => __( 'Fail an assignment', 'academy-pro' ),
			'academy_pro_gamipress_fail_specific_assignment' => __( 'Fail a specific assignment', 'academy-pro' ),
			'academy_pro_gamipress_fail_assignment_specific_course' => __( 'Fail an assignment in a specific course', 'academy-pro' ),

			// Course Triggers
			'academy_pro_gamipress_enroll_course' => __( 'Enroll a course', 'academy-pro' ),
			'academy_pro_gamipress_enroll_specific_course' => __( 'Enroll a specific course', 'academy-pro' ),
			'academy_pro_gamipress_complete_course' => __( 'Complete a course', 'academy-pro' ),
		);

		return $triggers;
	}

	public function add_label_to_specific_activity_trigger( $specific_activity_trigger_labels ) {
		// Quiz
		/* translators: %s is a quizname. */
		$specific_activity_trigger_labels['academy_pro_gamipress_complete_specific_quiz'] = __( 'Complete the quiz %s', 'academy-pro' );
		/* translators: %s is a quizname. */
		$specific_activity_trigger_labels['academy_pro_gamipress_pass_specific_quiz'] = __( 'Pass the quiz %s', 'academy-pro' );
		/* translators: %s is a quizname. */
		$specific_activity_trigger_labels['academy_pro_gamipress_fail_specific_quiz'] = __( 'Fail the quiz %s', 'academy-pro' );
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_complete_quiz_specific_course'] = __( 'Complete a quiz in the course %s', 'academy-pro' );
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_pass_quiz_specific_course'] = __( 'Pass a quiz in the course %s', 'academy-pro' );
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_fail_quiz_specific_course'] = __( 'Fail a quiz in the course %s', 'academy-pro' );

		// Assignments
		/* translators: %s is a Assignments name. */
		$specific_activity_trigger_labels['academy_pro_gamipress_complete_specific_assignment'] = __( 'Complete the assignment %s', 'academy-pro' );
		/* translators: %s is a Assignments name. */
		$specific_activity_trigger_labels['academy_pro_gamipress_pass_specific_assignment'] = __( 'Pass the assignment %s', 'academy-pro' );
		/* translators: %s is a Assignments name. */
		$specific_activity_trigger_labels['academy_pro_gamipress_fail_specific_assignment'] = __( 'Fail the assignment %s', 'academy-pro' );
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_complete_assignment_specific_course'] = __( 'Complete an assignment in the course %s', 'academy-pro' );
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_pass_assignment_specific_course'] = __( 'Pass an assignment in the course %s', 'academy-pro' );
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_fail_assignment_specific_course'] = __( 'Fail an assignment in the course %s', 'academy-pro' );

		// Courses
		/* translators: %s is a coursename. */
		$specific_activity_trigger_labels['academy_pro_gamipress_enroll_specific_course'] = __( 'Enroll in the course %s', 'academy-pro' );

		return $specific_activity_trigger_labels;
	}

	public function add_gamipress_specific_activity_triggers( $specific_activity_triggers ) {
		// Specific Quiz
		$specific_activity_triggers['academy_pro_gamipress_complete_specific_quiz'] = array( 'academy_quiz' );
		$specific_activity_triggers['academy_pro_gamipress_pass_specific_quiz'] = array( 'academy_quiz' );
		$specific_activity_triggers['academy_pro_gamipress_fail_specific_quiz'] = array( 'academy_quiz' );

		// Specific Quiz of a course
		$specific_activity_triggers['academy_pro_gamipress_complete_quiz_specific_course'] = array( 'academy_courses' );
		$specific_activity_triggers['academy_pro_gamipress_pass_quiz_specific_course'] = array( 'academy_courses' );
		$specific_activity_triggers['academy_pro_gamipress_fail_quiz_specific_course'] = array( 'academy_courses' );

		// Specific Assignment
		$specific_activity_triggers['academy_pro_gamipress_complete_specific_assignment'] = array( 'academy_assignments' );
		$specific_activity_triggers['academy_pro_gamipress_pass_specific_assignment'] = array( 'academy_assignments' );
		$specific_activity_triggers['academy_pro_gamipress_fail_specific_assignment'] = array( 'academy_assignments' );

		// Specific Assignment of a course
		$specific_activity_triggers['academy_pro_gamipress_complete_assignment_specific_course'] = array( 'academy_courses' );
		$specific_activity_triggers['academy_pro_gamipress_pass_assignment_specific_course'] = array( 'academy_courses' );
		$specific_activity_triggers['academy_pro_gamipress_fail_assignment_specific_course'] = array( 'academy_courses' );

		// Specific Course Enrollment
		$specific_activity_triggers['academy_pro_gamipress_enroll_specific_course'] = array( 'academy_courses' );

		return $specific_activity_triggers;
	}

	public function get_specific_trigger_id( $specific_id, $trigger = '', $args = array() ) {
		switch ( $trigger ) {
			case 'academy_pro_gamipress_pass_specific_quiz':
			case 'academy_pro_gamipress_complete_specific_quiz':
			case 'academy_pro_gamipress_fail_specific_quiz':
			case 'academy_pro_gamipress_complete_specific_assignment':
			case 'academy_pro_gamipress_pass_specific_assignment':
			case 'academy_pro_gamipress_fail_specific_assignment':
				$specific_id = $args[0];
				break;
			case 'academy_pro_gamipress_complete_quiz_specific_course':
			case 'academy_pro_gamipress_pass_quiz_specific_course':
			case 'academy_pro_gamipress_fail_quiz_specific_course':
			case 'academy_pro_gamipress_complete_assignment_specific_course':
			case 'academy_pro_gamipress_pass_assignment_specific_course':
			case 'academy_pro_gamipress_fail_assignment_specific_course':
				$specific_id = $args[2];
				break;
			case 'academy_pro_gamipress_enroll_specific_course':
				$specific_id = $args[1];
				break;
		}//end switch

		return $specific_id;
	}

	public function get_and_modify_user_id_for_trigger( $user_id, $trigger, $args ) {
		switch ( $trigger ) {
			// Quizzes
			case 'academy_pro_gamipress_complete_quiz':
			case 'academy_pro_gamipress_pass_quiz':
			case 'academy_pro_gamipress_fail_quiz':
				// Assignments
			case 'academy_pro_gamipress_complete_assignment':
			case 'academy_pro_gamipress_pass_assignment':
			case 'academy_pro_gamipress_fail_assignment':
				// Courses
			case 'academy_pro_gamipress_enroll_course':
				$user_id = $args[1];
				break;
			case 'academy_pro_gamipress_enroll_specific_course':
				$user_id = $args[0];
				break;
		}

		return $user_id;
	}

	public function get_and_modify_log_event_trigger_meta_data( $log_meta, $user_id, $trigger, $site_id, $args ) {
		switch ( $trigger ) {
			// Quizzes
			case 'academy_pro_gamipress_complete_quiz':
			case 'academy_pro_gamipress_pass_quiz':
			case 'academy_pro_gamipress_fail_quiz':
				$log_meta['quiz_id'] = $args[0];
				$log_meta['course_id'] = $args[2];
				break;

			// Assignments
			case 'academy_pro_gamipress_complete_assignments':
			case 'academy_pro_gamipress_pass_assignment':
			case 'academy_pro_gamipress_fail_assignment':
				$log_meta['assignment_id'] = $args[0];
				$log_meta['course_id'] = $args[2];
				break;

			// Courses
			case 'academy_pro_gamipress_enroll_course':
				$log_meta['course_id'] = $args[0];
				break;
		}//end switch

		return $log_meta;
	}
}
