<?php
namespace AcademyProGoogleClassroom;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Hooks {
	public static function init() {
		$self = new self();
		// set continue learning url
		add_filter( 'academy/templates/start_course_url', array( $self, 'start_course_url' ) );
		// frontend stream template
		add_action( 'academy/templates/single_course_content', array( $self, 'academy_single_course_stream' ), 33 );
	}

	public function start_course_url( $url ) {
		if ( ! \Academy\Helper::get_addon_active_status( 'google-classroom' ) ) {
			return $url;
		}
		$course_id = get_the_ID();
		$is_google_classroom = get_post_meta( $course_id, 'academy_google_classroom_id', true );
		if ( empty( $is_google_classroom ) ) {
			return $url;
		}
		$alternative_link = get_post_meta( $course_id, 'academy_classroom_alternative_link', true );
		if ( empty( $alternative_link ) ) {
			return $url;
		}
		return $alternative_link;
	}

	public function academy_single_course_stream() {
		$course_id = get_the_ID();
		$title = get_post_meta( $course_id, 'academy_google_classroom_title', true );
		$invite_code = get_post_meta( $course_id, 'academy_classroom_invite_code', true );
		$classroom_url = get_post_meta( $course_id, 'academy_classroom_alternative_link', true );
		if ( ! $classroom_url || ! $invite_code ) {
			return;
		}
		$is_enrolled = \Academy\Helper::is_enrolled( $course_id, get_current_user_id() );
		if ( $is_enrolled ) {
			\AcademyPro\Helper::get_template( 'google-classroom/stream.php', array(
				'title' => $title,
				'join_code'  => $invite_code,
				'classroom_url' => $classroom_url
			) );
		}
	}

}
