<?php
namespace AcademyProGradeBook;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use mysqli_result;

class Helper {
	public static function insert_quiz_result( $args ) {
		global $wpdb;

		$default = array(
			'user_id'           => 0,
			'course_id'         => 0,
			'quiz_id'           => 0,
			'assignment_id'     => 0,
			'gradebook_id'      => 0,
			'result_for'        => '',
			'grade_name'        => '',
			'grade_point'       => 0.00,
			'user_grade_point'  => 0.00,
			'earned_percentage' => 0,
		);

		$data = wp_parse_args( $args, $default );

		$data['user_grade_point']  = number_format( $data['user_grade_point'], 2 );
		$data['grade_point']       = number_format( $data['grade_point'], 2 );
		$data['earned_percentage'] = number_format( $data['earned_percentage'], 2 );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$count = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_book_results 
		WHERE user_id=%d AND course_id = %d AND quiz_id = %d ",
				$data['user_id'],
				$data['course_id'],
				$data['quiz_id'],
			)
		);

		if ( 0 < $count ) {
			$data['updated_at'] = current_time( 'mysql' );
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			return $wpdb->update(
				"{$wpdb->prefix}academy_grade_book_results",
				$data,
				array(
					'user_id'   => $data['user_id'],
					'course_id' => $data['course_id'],
					'quiz_id'   => $data['quiz_id'],
				),
				array(
					'%d',
					'%d',
					'%d',
					'%d',
					'%d',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'
				),
				array(
					'%d',
					'%d',
					'%d'
				)
			);
		}//end if

		$data['created_at'] = current_time( 'mysql' );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->insert(
			"{$wpdb->prefix}academy_grade_book_results",
			$data,
			array(
				'%d',
				'%d',
				'%d',
				'%d',
				'%d',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s'
			)
		);
	}

	public static function insert_assignment_result( $args ) {
		global $wpdb;

		$default = array(
			'user_id'           => 0,
			'course_id'         => 0,
			'quiz_id'           => 0,
			'assignment_id'     => 0,
			'gradebook_id'      => 0,
			'result_for'        => '',
			'grade_name'        => '',
			'grade_point'       => 0.00,
			'user_grade_point'  => 0.00,
			'earned_percentage' => 0.00,
		);

		$data = wp_parse_args( $args, $default );

		$data['grade_point']       = number_format( $data['grade_point'], 2 );
		$data['user_grade_point']  = number_format( $data['user_grade_point'], 2 );
		$data['earned_percentage'] = number_format( $data['earned_percentage'], 2 );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$count = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_book_results 
		WHERE user_id=%d AND course_id = %d AND assignment_id = %d ",
				$data['user_id'],
				$data['course_id'],
				$data['assignment_id'],
			)
		);

		if ( 0 < $count ) {
			$data['updated_at'] = current_time( 'mysql' );
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			return $wpdb->update(
				"{$wpdb->prefix}academy_grade_book_results",
				$data,
				array(
					'user_id'   => $data['user_id'],
					'course_id' => $data['course_id'],
					'assignment_id'   => $data['assignment_id'],
				),
				array(
					'%d',
					'%d',
					'%d',
					'%d',
					'%d',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s',
					'%s'
				),
				array(
					'%d',
					'%d',
					'%d'
				)
			);
		}//end if

		$data['created_at'] = current_time( 'mysql' );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->insert(
			"{$wpdb->prefix}academy_grade_book_results",
			$data,
			array(
				'%d',
				'%d',
				'%d',
				'%d',
				'%d',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s'
			)
		);
	}

	public static function create_or_update_final_grade( $args ) {
		global $wpdb;

		$default = array(
			'user_id'    => 0,
			'course_id'  => 0,
		);

		$data = wp_parse_args( $args, $default );

		$previous_details = self::get_student_grade( $data );
		$final_gp         = 0;
		$final_percentage = 0;
		$count            = 0;

		foreach ( $previous_details as $details ) {
			if ( 'final' !== $details->result_for ) {
				$final_gp         += $details->user_grade_point;
				$final_percentage += $details->earned_percentage;
				$count++;
			}
		}

		$final_percentage = 0 < $count ? $final_percentage / $count : 0;
		$final_gp         = 0 < $count ? $final_gp / $count : 0;

		$grade_details = current( self::get_grade_details_by_gp( $final_gp ) );

		$data['quiz_id']           = 0;
		$data['assignment_id']     = 0;
		$data['grade_point']       = number_format( self::get_max_grade_point(), 2 );
		$data['grade_name']        = $grade_details->grade_name;
		$data['result_for']        = 'final';
		$data['gradebook_id']      = $grade_details->gradebook_id;
		$data['user_grade_point']  = number_format( $final_gp, 2 );
		$data['earned_percentage'] = number_format( $final_percentage, 2 );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$if_exists = $wpdb->get_var(
			$wpdb->prepare(
				"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_book_results WHERE result_for=%s AND user_id=%d AND course_id =%d",
				array(
					'final',
					$data['user_id'],
					$data['course_id'],
				)
			)
		);

		if ( $if_exists ) {
			$data['updated_at'] = current_time( 'mysql' );
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			return $wpdb->update(
				"{$wpdb->prefix}academy_grade_book_results",
				$data,
				array(
					'user_id'    => $data['user_id'],
					'course_id'  => $data['course_id'],
					'result_for' => $data['result_for'],
				),
				array(
					'%d',
					'%d',
					'%d',
					'%d',
					'%s',
					'%s',
					'%s',
					'%d',
					'%s',
					'%s',
					'%s'
				),
				array(
					'%d',
					'%d',
					'%s'
				)
			);
		} else {
			$data['created_at'] = current_time( 'mysql' );
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			return $wpdb->insert(
				"{$wpdb->prefix}academy_grade_book_results",
				$data,
				array(
					'%d',
					'%d',
					'%d',
					'%d',
					'%s',
					'%s',
					'%s',
					'%d',
					'%s',
					'%s',
					'%s'
				)
			);
		}//end if
	}

	public static function get_grade_by_percentage( $percentage ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_results( $wpdb->prepare(
			"SELECT gradebook_id, grade_name, grade_point FROM {$wpdb->prefix}academy_grade_books WHERE percent_from <= %d AND percent_to >= %d ORDER BY gradebook_id LIMIT 1",
			(int) $percentage,
			(int) $percentage
		), OBJECT );
	}

	public static function get_grade_details_by_gp( $grade_point ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_results( $wpdb->prepare(
			"SELECT gradebook_id, grade_name FROM {$wpdb->prefix}academy_grade_books
				WHERE grade_point = (
					SELECT MAX(grade_point)
					FROM {$wpdb->prefix}academy_grade_books
					WHERE grade_point <= %s
				)", $grade_point ), OBJECT );
	}

	public static function get_max_grade_point(): ?string {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_var( "SELECT MAX(grade_point) FROM {$wpdb->prefix}academy_grade_books" );
	}

	public static function import_grade_book_sample_data() {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->query( "INSERT INTO {$wpdb->prefix}academy_grade_books (grade_name, grade_point, percent_from, percent_to, grade_config) VALUES
			('A+', '4.0', 90, 100, 'a:1:{s:11:\"grade_color\";s:7:\"#27ae60\";}'),
			('A', '3.50', 80, 89, 'a:1:{s:11:\"grade_color\";s:7:\"#1bbc9b\";}'),
			('A-', '3.0', 70, 79, 'a:1:{s:11:\"grade_color\";s:7:\"#43bca4\";}'),
			('B+', '2.50', 60, 69, 'a:1:{s:11:\"grade_color\";s:7:\"#1f3a93\";}'),
			('B', '2.0', 50, 59, 'a:1:{s:11:\"grade_color\";s:7:\"#2574a9\";}'),
			('B-', '1.5', 40, 49, 'a:1:{s:11:\"grade_color\";s:7:\"#19b5fe\";}'),
			('C', '1.0', 30, 39, 'a:1:{s:11:\"grade_color\";s:7:\"#9a13b3\";}'),
			('F', '0.0', 0, 29, 'a:1:{s:11:\"grade_color\";s:7:\"#d71830\";}');" );
	}

	public static function grade_book_validation( $args ) {
		global $wpdb;

		$default = array(
			'percent_from' => 0,
			'percent_to'   => 0,
			'grade_point'  => 0,
			'grade_name'   => '',
			'gradebook_id' => 0,
		);

		$data = wp_parse_args( $args, $default );

		$data['grade_point'] = (float) $data['grade_point'];
		$data['percent_from'] = (float) $data['percent_from'];
		$data['percent_to'] = (float) $data['percent_to'];

		// check if the percentage from is greater than percentage to
		if ( $data['percent_from'] > $data['percent_to'] ) {
			return array(
				'message' => __( 'Percentage from should be less than percentage to', 'academy-pro' ),
			);
		}
		// percentage checker
		if ( $data['percent_from'] > 100 || $data['percent_to'] > 100 ) {
			return array(
				'message' => __( 'Percentage should be less than 100', 'academy-pro' ),
			);
		}
		// Check for grade name
		if ( $data['gradebook_id'] ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$check_grade_name = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_books WHERE grade_name = %s AND gradebook_id != %d",
					$data['grade_name'],
					$data['gradebook_id']
				)
			);
		} else {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$check_grade_name = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_books WHERE grade_name = %s",
					$data['grade_name']
				)
			);
		}
		if ( $check_grade_name > 0 ) {
			return array(
				'message' => __( 'Grade name already exists', 'academy-pro' ),
			);
		}

		// Check for grade point
		if ( $data['gradebook_id'] ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$check_grade_point = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_books WHERE grade_point = %s AND gradebook_id != %d",
					$data['grade_point'],
					$data['gradebook_id']
				)
			);
		} else {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$check_grade_point = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_books WHERE grade_point = %f",
					$data['grade_point']
				)
			);
		}
		if ( $check_grade_point > 0 ) {
			return array(
				'message' => __( 'Grade point already exists', 'academy-pro' ),
			);
		}

		// Check for percentage range
		if ( $data['gradebook_id'] ) {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$check_percentage_range = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_books WHERE percent_from = %f AND percent_to = %f AND gradebook_id != %d",
					$data['percent_from'],
					$data['percent_to'],
					$data['gradebook_id']
				)
			);
		} else {
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
			$check_percentage_range = $wpdb->get_var(
				$wpdb->prepare(
					"SELECT COUNT(*) FROM {$wpdb->prefix}academy_grade_books WHERE percent_from = %f AND percent_to = %f",
					$data['percent_from'],
					$data['percent_to']
				)
			);
		}
		if ( $check_percentage_range > 0 ) {
			return array(
				'message' => __( 'Percentage range already exists', 'academy-pro' ),
			);
		}

		return false;
	}
	public static function add_new_grade_book( $args ) {
		global $wpdb;

		$default = array(
			'grade_name'   => '',
			'grade_point'  => 0,
			'percent_from' => 0,
			'percent_to'   => 0,
			'grade_config' => '',
			'created_at'   => current_time( 'mysql' ),
		);

		$data = wp_parse_args( $args, $default );

		$data['percent_from'] = number_format( $data['percent_from'], 2 );
		$data['percent_to']   = number_format( $data['percent_to'], 2 );
		$data['grade_point']  = number_format( $data['grade_point'], 2 );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->insert(
			"{$wpdb->prefix}academy_grade_books",
			$data,
			array(
				'%s',
				'%s',
				'%s',
				'%s',
				'%s',
				'%s'
			)
		);
	}

	public static function update_grade_book( $args ) {
		global $wpdb;

		$default = array(
			'grade_name'   => '',
			'grade_point'  => 0,
			'percent_from' => 0,
			'percent_to'   => 0,
			'grade_config' => '',
			'updated_at'   => current_time( 'mysql' ),
		);

		$data = wp_parse_args( $args, $default );

		$data['percent_from'] = number_format( $data['percent_from'], 2 );
		$data['percent_to']   = number_format( $data['percent_to'], 2 );
		$data['grade_point']  = number_format( $data['grade_point'], 2 );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->update(
			"{$wpdb->prefix}academy_grade_books",
			$data,
			array(
				'gradebook_id' => $data['gradebook_id']
			),
			array(
				'%s',
				'%f',
				'%f',
				'%f',
				'%s',
				'%s'
			),
			array(
				'%d'
			)
		);
	}

	public static function delete_grade_book( $id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->delete(
			$wpdb->prefix . 'academy_grade_books',
			array(
				'gradebook_id' => $id,
			),
			array(
				'%d',
			)
		);
	}

	public static function delete_grade_book_result( $id ) {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->delete(
			$wpdb->prefix . 'academy_grade_book_results',
			array(
				'gradebook_result_id' => $id,
			),
			array(
				'%d',
			)
		);
	}

	public static function delete_single_grade_book_result( $args ) {
		global $wpdb;

		$default = array(
			'gradebook_result_id' => 0,
			'course_id' => 0,
			'user_id' => get_current_user_id(),
		);

		$args = wp_parse_args( $args, $default );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$delete = $wpdb->delete(
			$wpdb->prefix . 'academy_grade_book_results',
			array(
				'gradebook_result_id' => $args['gradebook_result_id']
			),
			array(
				'%d',
			)
		);

		if ( $delete ) {
			$args = array(
				'course_id' => $args['course_id'],
				'user_id' => $args['user_id'],
			);

			$updated = self::create_or_update_final_grade( $args );

			if ( $updated ) {
				return $delete;
			}
		}

		return $delete;
	}

	public static function get_all_grades( $args ) {
		global $wpdb;

		$default = array(
			'per_page' => 10,
			'offset' => 0,
			'search' => null,
		);

		$data = wp_parse_args( $args, $default );

		$query = "SELECT * FROM {$wpdb->prefix}academy_grade_books";

		if ( $data['search'] ) {
			$query .= ' WHERE ';
			$like = '%' . $wpdb->esc_like( $data['search'] ) . '%';
			$query .= $wpdb->prepare( 'grade_name LIKE %s', $like );
		}

		$query   .= $wpdb->prepare( ' ORDER BY grade_point DESC LIMIT %d, %d', $data['offset'], $data['per_page'] );
		// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$grade_books = $wpdb->get_results( $query, OBJECT );
		header( 'x-wp-total:' . count( $grade_books ) );
		foreach ( $grade_books as $gradebook ) {
			$gradebook->grade_config = maybe_unserialize( $gradebook->grade_config );
		}

		return $grade_books;
	}

	public static function get_the_latest_grade() {
		global $wpdb;

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		$gradebook = $wpdb->get_results(
			"SELECT * FROM {$wpdb->prefix}academy_grade_books ORDER BY gradebook_id DESC LIMIT 1",
			OBJECT
		);
		if ( $gradebook ) {
			$gradebook = current( $gradebook );
			$gradebook->grade_config = maybe_unserialize( $gradebook->grade_config );
		}

		return $gradebook;
	}

	public static function get_student_grade( $args ) {
		global $wpdb;

		$default = array(
			'course_id' => 0,
			'user_id'   => 0,
		);

		$data = wp_parse_args( $args, $default );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM {$wpdb->prefix}academy_grade_book_results WHERE course_id = %d AND user_id = %d ORDER BY gradebook_result_id ASC",
				$data['course_id'],
				$data['user_id']
			),
			OBJECT
		);
	}

	public static function get_all_or_single_student_grade_details_depend_on_args( $args ) {
		global $wpdb;

		$default = array(
			'per_page' => 10,
			'offset' => 0,
			'search' => null,
			'user_id' => null,
			'course_id' => null,
		);

		$data = wp_parse_args( $args, $default );

		$query = "SELECT 
			gradebook_result.*,
				(SELECT COUNT(quizzes.quiz_id) FROM {$wpdb->prefix}academy_grade_book_results quizzes WHERE quizzes.user_id = gradebook_result.user_id AND quizzes.course_id = gradebook_result.course_id AND quizzes.result_for = 'quiz') as quiz_count,
				(SELECT COUNT(assignments.assignment_id) FROM {$wpdb->prefix}academy_grade_book_results assignments WHERE assignments.user_id = gradebook_result.user_id AND assignments.course_id = gradebook_result.course_id AND assignments.result_for = 'assignment') as assignment_count,
				student.display_name,
				student.user_email,
				course.post_title as course_title,
				gradebook.grade_config
			FROM {$wpdb->prefix}academy_grade_book_results gradebook_result
				LEFT JOIN {$wpdb->prefix}academy_grade_books gradebook ON (gradebook_result.gradebook_id = gradebook.gradebook_id) OR (gradebook_result.grade_name = gradebook.grade_name AND gradebook_result.gradebook_id != gradebook.gradebook_id)
				LEFT JOIN {$wpdb->posts} course ON gradebook_result.course_id = course.ID
				LEFT JOIN {$wpdb->users} student ON gradebook_result.user_id = student.ID
		WHERE gradebook_result.result_for = 'final'";

		if ( $data['search'] ) {
			$query .= ' AND (';
			$like = '%' . $wpdb->esc_like( $data['search'] ) . '%';
			$query .= $wpdb->prepare( ' student.display_name LIKE %s OR course.post_title LIKE %s OR user_email LIKE %s OR earned_percentage LIKE %s )', $like, $like, $like, $like );
		}

		if ( $data['course_id'] && $data['user_id'] ) {
			$len = strlen( $query ) - strlen( "gradebook_result.result_for = 'final'" );
			$query = substr( $query, 0, $len );
			$query .= $wpdb->prepare( 'gradebook_result.user_id = %d AND gradebook_result.course_id = %d', $data['user_id'], $data['course_id'] );
		}

		$query .= $wpdb->prepare( ' ORDER BY gradebook_result_id DESC LIMIT %d, %d', $data['offset'], $data['per_page'] );
		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.PreparedSQL.NotPrepared
		$grade_books = $wpdb->get_results( $query, OBJECT );

		foreach ( $grade_books as $gradebook ) {
			$gradebook->course_curriculum = \Academy\Helper::get_course_curriculums_number_of_counts( $gradebook->course_id );
			$gradebook->grade_config = maybe_unserialize( $gradebook->grade_config );
		}

		return $grade_books;
	}

	public static function get_student_quiz_grade_by_course_quiz_and_user_id( $args ) {
		global $wpdb;

		$default = array(
			'user_id'   => null,
			'course_id' => null,
			'quiz_id'   => null,
		);

		$data = wp_parse_args( $args, $default );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_results($wpdb->prepare(
			"SELECT gb.gradebook_id, gb.user_id, gb.course_id, gb.quiz_id, gb.grade_name, gb.user_grade_point, gb.earned_percentage, gc.grade_config
		    FROM {$wpdb->prefix}academy_grade_book_results AS gb
		    LEFT JOIN {$wpdb->prefix}academy_grade_books AS gc ON gb.gradebook_id = gc.gradebook_id
		    WHERE gb.user_id = %d AND gb.course_id = %d AND gb.quiz_id = %d",
			$data['user_id'], $data['course_id'], $data['quiz_id']
		), OBJECT);
	}

	public static function get_student_assignment_grade_by_course_assignment_and_user_id( $args ) {
		global $wpdb;

		$default = array(
			'user_id'         => null,
			'course_id'       => null,
			'assignment_id'   => null,
		);

		$data = wp_parse_args( $args, $default );

		// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
		return $wpdb->get_results($wpdb->prepare(
			"SELECT gb.gradebook_id, gb.user_id, gb.course_id, gb.assignment_id, gb.grade_name, gb.user_grade_point, gb.earned_percentage, gc.grade_config
		    FROM {$wpdb->prefix}academy_grade_book_results AS gb
		    LEFT JOIN {$wpdb->prefix}academy_grade_books AS gc ON gb.gradebook_id = gc.gradebook_id
		    WHERE gb.user_id = %d AND gb.course_id = %d AND gb.assignment_id = %d",
			$data['user_id'], $data['course_id'], $data['assignment_id']
		), OBJECT);
	}
}

