<?php
namespace AcademyProGroupPlus\Dashboard\Ajax\Admin;

use Academy\Classes\AbstractAjaxHandler;
use Academy\Classes\Sanitizer;
use AcademyProGroupPlus\Db\Models\Group;
use AcademyProGroupPlus\Roles\{
	GroupOrganizer,
	TeamOrganizer
};
use WP_User;
use WP_User_Query;
use AcademyProGroupPlus\interfaces\Ajax\OrganizerHandlerInterface;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class OrganizerHandler extends AbstractAjaxHandler implements OrganizerHandlerInterface {

	protected $namespace = 'academy_pro_group_plus';
	public function __construct() {
		$this->actions = array(
			'get_organizers' => array(
				'callback' => array( $this, 'get_organizers' ),
				'capability' => 'academy_team_member',
			),
			'get_team_members' => array(
				'callback' => array( $this, 'get_team_members' ),
				'capability' => 'academy_team_member',
			),
		);
	}
	public function get_organizers( $payload_data ) : void {
		$payload = Sanitizer::sanitize_payload([
			'search'  => 'string',
			'page'    => 'integer',
		], $payload_data);

		$args = [
			'number' => 20,
			'paged'  => abs( intval( $payload['page'] ?? 1 ) ),
			'role__in' => [ 'academy_group_organizer', 'academy_team_organizer' ],
		];

		if ( ! empty( $email = $payload['email_search'] ?? '' ) ) {
			$args['search_columns'] = [ 'user_email' ];
			$args['search']         = '*' . $email . '*';
		}

		$user_query = new WP_User_Query( $args );

		$output = [];

		$output['current_page'] = $args['paged'];
		$output['total_page']   = ceil( $user_query->get_total() / $args['number'] );

		if ( ! empty( $users = $user_query->get_results() ) ) {
			foreach ( $users as $user ) {

				if (
					! current_user_can( 'manage_options' ) &&
					(
						in_array( 'administrator', $user->roles ) ||
						in_array( 'editor', $user->roles )
					)
				) {
					continue;
				}

				$output['users'][] = [
					'id'           => intval( $user->ID ),
					'display_name' => $user->display_name,
					'email'        => $user->user_email,
				];
			}
		}
		wp_send_json_success( $output );
	}

	public function get_team_members( $payload_data ) : void {
		$payload = Sanitizer::sanitize_payload([
			'search'  => 'string',
			'page'    => 'integer',
		], $payload_data);

		$args = [
			'number' => 20,
			'paged'  => abs( intval( $payload['page'] ?? 1 ) ),
		];

		if ( ! empty( $email = $payload['email_search'] ?? '' ) ) {
			$args['search_columns'] = [ 'user_email' ];
			$args['search']         = '*' . $email . '*';
		}

		$user_query = new WP_User_Query( $args );

		$output = [];

		$output['current_page'] = $args['paged'];
		$output['total_page']   = ceil( $user_query->get_total() / $args['number'] );
		$output['users'] = [];
		if ( ! empty( $users = $user_query->get_results() ) ) {
			foreach ( $users as $user ) {

				if (
					! current_user_can( 'manage_options' ) &&
					(
						in_array( 'administrator', $user->roles ) ||
						in_array( 'editor', $user->roles ) ||
						in_array( 'academy_team_organizer', $user->roles ) ||
						in_array( 'academy_group_organizer', $user->roles )
					)
				) {
					continue;
				}

				$output['users'][] = [
					'id'           => intval( $user->ID ),
					'display_name' => $user->display_name,
					'email'        => $user->user_email,
				];
			}
		}//end if
		wp_send_json_success( $output );
	}
}
