<?php
namespace AcademyProGroupPlus\Db;

use AcademyProGroupPlus\Interfaces\Db\CommonInterface;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class Common
 */
abstract class Common implements CommonInterface {



	/** @var string $prefix */
	protected string $prefix;

	/** @var string $charset_collate */
	protected string $charset_collate;

	/** @var string $table */
	protected string $table;

	/**
	 * Constructor
	 */
	public function __construct() {
		global $wpdb;
		$this->prefix         = $wpdb->prefix . ACADEMY_PLUGIN_SLUG . '_';
		$this->table          = $this->prefix . $this->table;
		$this->charset_collate = $wpdb->get_charset_collate();
	}

	public static function add_prefix( string $table ) : string {
		global $wpdb;
		return $wpdb->prefix . ACADEMY_PLUGIN_SLUG . '_' . $table;
	}
}
