<?php
namespace AcademyProGroupPlus\Db\Migrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class CreateGroupsTable
 */
final class CreateGroupCoursesTable extends Migration {

	/** @var string $table */
	protected string $table = 'group_courses';

	/**
	 * @method up
	 * Run query on addon activation
	 * @return string
	 */
	public function up(): string {
		global $wpdb;
		return "
			CREATE TABLE IF NOT EXISTS {$this->table}
			(
				id          INT 	     AUTO_INCREMENT PRIMARY KEY,
				group_id    INT          NOT NULL COMMENT 'Group ID', 
				course_id   BIGINT       UNSIGNED NOT NULL COMMENT 'Course ID',
				user_id     BIGINT       NULL     COMMENT 'User ID',
				total_seats INT          NOT NULL COMMENT 'Total Seats', 
				req_seats   INT          NULL COMMENT 'Requested Seats', 
				updated_at  TIMESTAMP    DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				FOREIGN KEY (group_id) 
					REFERENCES {$this->prefix}groups(id)
						ON DELETE CASCADE
						ON UPDATE CASCADE,
				FOREIGN KEY (course_id) 
					REFERENCES {$wpdb->prefix}posts(ID)
						ON DELETE CASCADE
						ON UPDATE CASCADE
			) {$this->charset_collate};
		";
	}

	/**
	 * @method down
	 * Run query on addon deactivation
	 * @return string
	 */
	public function down(): string {
		// nothing
		return '';
	}

}
