<?php
namespace AcademyProGroupPlus\Db\Migrations;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class CreateGroupOrganizersTable
 */
final class CreateGroupOrganizersTable extends Migration {

	/** @var string $table */
	protected string $table = 'group_organizers';

	/**
	 * @method up
	 * Run query on addon activation
	 * @return string
	 */
	public function up(): string {
		global $wpdb;
		return "
			CREATE TABLE IF NOT EXISTS {$this->table}
			(
				id             INT 	     AUTO_INCREMENT PRIMARY KEY,
				group_id       INT       NOT NULL COMMENT 'Group ID', 
				organizer_id   BIGINT    UNSIGNED NOT NULL COMMENT 'Course ID',
				user_id        BIGINT    NULL     COMMENT 'User ID',
				updated_at     TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
				FOREIGN KEY (group_id) 
					REFERENCES {$this->prefix}groups(id)
						ON DELETE CASCADE
						ON UPDATE CASCADE,
				FOREIGN KEY (organizer_id) 
					REFERENCES {$wpdb->prefix}users(ID)
						ON DELETE CASCADE
						ON UPDATE CASCADE
			) {$this->charset_collate};
		";
	}

	/**
	 * @method down
	 * Run query on addon deactivation
	 * @return string
	 */
	public function down(): string {
		// nothing
		return '';
	}

}
