<?php
namespace AcademyProGroupPlus\Db\Migrations;

use AcademyProGroupPlus\Db\Common;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @class Migration
 */
abstract class Migration extends Common {

	/**
	 * @method up
	 * Run query on addon activation
	 * @return string
	 */
	abstract public function up(): string;

	/**
	 * @method down
	 * Run query on addon deactivation
	 * @return string
	 */
	abstract public function down(): string;

	/**
	 * @method runOnActivation
	 * Run code statement on addon activation
	 * @return void
	 */
	public static function runOnActivation(): void {
		self::execute( ( new static() )->up() );
	}

	/**
	 * @method runOnDeactivation
	 * Run code statement on addon deactivation
	 * @return void
	 */
	public static function runOnDeactivation(): void {
		self::execute( ( new static() )->down() );
	}

	/**
	 * @method execute
	 * Run SQL Query
	 * @param  string $query
	 * @return void
	 */
	protected static function execute( string $query ): void {
		if ( empty( $query ) ) {
			return;
		}
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
		dbDelta( $query );
	}
}
