<?php
namespace AcademyProMailChimp\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Settings {
	public static function get_saved_data() {
		$settings = get_option( ACADEMY_PRO_MAILCHIMP_SETTINGS_NAME );
		if ( $settings ) {
			return json_decode( $settings, true );
		}
		return [];
	}
	public static function get_default_data() {
		return apply_filters('academy_pro_mailchimp/settings_default_data', [
			'is_enable_force_subscription' => false,
			'api_key'                      => '',
			'subscriber_consent_message'   => '',
			'triggers'                     => [
				'student_registration'    => [
					'enable'      => false,
					'list_id'     => '',
					'group_id'    => '',
					'interest_id' => ''
				],
				'instructor_registration' => [
					'enable'      => false,
					'list_id'     => '',
					'group_id'    => '',
					'interest_id' => ''
				],
				'course_enroll'           => [
					'enable'      => false,
					'list_id'     => '',
					'group_id'    => '',
					'interest_id' => ''
				]
			]
		]);
	}

	public static function save_settings( $form_data = false ) {
		$default_data = self::get_default_data();
		$saved_data = self::get_saved_data();
		$settings_data = wp_parse_args( $saved_data, $default_data );
		if ( $form_data ) {
			$settings_data = wp_parse_args( $form_data, $settings_data );
		}
		// if settings already saved, then update it
		if ( count( $saved_data ) ) {
			return update_option( ACADEMY_PRO_MAILCHIMP_SETTINGS_NAME, wp_json_encode( $settings_data ) );
		}
		return add_option( ACADEMY_PRO_MAILCHIMP_SETTINGS_NAME, wp_json_encode( $settings_data ) );
	}
}
