<?php
namespace AcademyProMeeting;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Database {

	public static function init() {
		$self = new self();
		add_action( 'init', [ $self, 'create_academy_meeting_post_type' ] );
		add_action( 'rest_api_init', [ $self, 'register_academy_meeting_meta' ] );
	}

	public function create_academy_meeting_post_type() {
		$post_type = 'academy_meeting';
		register_post_type(
			$post_type,
			array(
				'labels'                => array(
					'name'                  => esc_html__( 'Meetings', 'academy-pro' ),
					'singular_name'         => esc_html__( 'Meeting', 'academy-pro' ),
					'search_items'          => esc_html__( 'Search Meetings', 'academy-pro' ),
					'parent_item_colon'     => esc_html__( 'Parent Meeting:', 'academy-pro' ),
					'not_found'             => esc_html__( 'No meetings found.', 'academy-pro' ),
					'not_found_in_trash'    => esc_html__( 'No meetings found in Trash.', 'academy-pro' ),
					'archives'              => esc_html__( 'Meeting Archives', 'academy-pro' ),
				),
				'public'                => true,
				'publicly_queryable'    => true,
				'show_ui'               => false,
				'show_in_menu'          => false,
				'hierarchical'          => true,
				'rewrite'               => array( 'slug' => 'meeting' ),
				'query_var'             => true,
				'has_archive'           => true,
				'delete_with_user'      => false,
				'supports'              => array( 'title', 'editor', 'custom-fields', 'comments', 'post-formats', 'author' ),
				'show_in_rest'          => true,
				'rest_base'             => $post_type,
				'rest_namespace'        => ACADEMY_PLUGIN_SLUG . '/v1',
				'rest_controller_class' => 'WP_REST_Posts_Controller',
				'capability_type'       => 'post',
				'capabilities'              => array(
					'edit_post'             => 'edit_academy_meeting',
					'read_post'             => 'read_academy_meeting',
					'delete_post'           => 'delete_academy_meeting',
					'delete_posts'          => 'delete_academy_meetings',
					'edit_posts'            => 'edit_academy_meetings',
					'edit_others_posts'     => 'edit_others_academy_meetings',
					'publish_posts'         => 'publish_academy_meetings',
					'read_private_posts'    => 'read_private_academy_meetings',
					'create_posts'          => 'edit_academy_meetings',
				),
			)
		);
	}

	public function register_academy_meeting_meta() {
		$meeting_meta = array(
			'academy_meeting_type'     => 'string',
			'academy_meeting_request'  => 'string',
			'academy_meeting_response' => 'string',
		);

		foreach ( $meeting_meta as $meta_key => $meta_value_type ) {
			register_meta(
				'post',
				$meta_key,
				array(
					'object_subtype' => 'academy_meeting',
					'type'           => $meta_value_type,
					'single'         => true,
					'show_in_rest'   => true,
				)
			);
		}
	}

}
