<?php
if ( ! function_exists( 'academy_pro_meeting_added_frontend_dashboard_menu' ) ) {
	function academy_pro_meeting_added_frontend_dashboard_menu( $menu ) {
		if ( current_user_can( 'manage_academy_instructor' ) ) {
			$menu['meeting'] = array(
				'label' => __( 'Meetings', 'academy-pro' ),
				'icon'  => 'academy-icon academy-icon--video',
				'public' => true,
				'priority' => 37,
			);
		}
		return $menu;
	}
}

if ( ! function_exists( 'academy_pro_meeting_frontend_dashboard_meetings_page' ) ) {
	function academy_pro_meeting_frontend_dashboard_meetings_page() {
		\AcademyPro\Helper::get_template(
			'frontend-dashboard/pages/meeting.php',
		);
	}
}

if ( ! function_exists( 'academy_pro_meeting_course_curriculum_meeting_content' ) ) {
	function academy_pro_meeting_course_curriculum_meeting_content( $course_id, $meeting_id ) {

		$meeting = get_post( $meeting_id );

		if ( $meeting ) {
			\AcademyPro\Helper::get_template(
				'curriculums/meeting.php',
				array(
					'course_id' => $course_id,
					'meeting_id' => $meeting_id,
				)
			);
		} else {
			\Academy\Helper::get_template( 'curriculums/not-found.php' );
		}

		do_action( 'academy/templates/curriculums/after_render_lesson_content', $meeting, $course_id, $meeting_id );

	}
}//end if
