<?php
namespace AcademyProMeeting;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Helper {
	public static function reamining_time_before_meeting_depend_on_timezone( $given_time, $timezone ) {
		$start_time = new \DateTime( $given_time, new \DateTimeZone( $timezone ) );
		$current_time = new \DateTime( 'now', new \DateTimeZone( $timezone ) );

		if ( $current_time > $start_time ) {
			$diff = $current_time->diff( $start_time );
			$diff->invert = 1;
			return $diff;
		}

		return $current_time->diff( $start_time );
	}

	public static function remaining_after_meeting_start_depend_on_time_zone( $given_time, $timezone ) {
		$end_time = new \DateTime( $given_time, new \DateTimeZone( $timezone ) );
		$current_time = new \DateTime( 'now', new \DateTimeZone( $timezone ) );

		if ( $current_time > $end_time ) {
			$diff = $current_time->diff( $end_time );
			$diff->invert = 1;
			return $diff;
		}

		return $current_time->diff( $end_time );
	}

	public static function render_meeting_for_php_rendering( $course_id, $meeting_id ) {
		$has_permission = \Academy\Helper::has_permission_to_access_curriculum( $course_id );
		if ( $has_permission ) {
			do_action( 'academy_pro_meeting/frontend/before_render_meeting', $course_id, $meeting_id );
			$is_meeting = get_post( $meeting_id );
			if ( ! $is_meeting ) {
				return false;
			}
			$meeting = json_decode( get_post_meta( $meeting_id, 'academy_meeting_response', true ), true );
			$meeting['description'] = get_post_field( 'post_content', $meeting_id );
			$meeting_author_id = (int) get_post_field( 'post_author', $meeting_id );
			$meeting['meeting_type'] = get_post_meta( $meeting_id, 'academy_meeting_type', true );
			$meeting['is_meeting_creator'] = get_current_user_id() === $meeting_author_id ? true : false;
			return $meeting;
		}//end if
		return false;
	}
}
