<?php
namespace AcademyProMeeting\Integration;

use AcademyProMeeting\Integration\Zoom;
use AcademyProMeeting\Integration\GoogleMeet;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Common {

	public static function init() {
		$self = new self();
		add_action( 'wp_ajax_academy_pro_meeting/get_meeting_credentials', array( $self, 'get_meeting_credentials' ) );
		add_action( 'wp_ajax_academy_pro_meeting/frontend/render_meeting', array( $self, 'render_meeting' ) );
		add_action( 'wp_ajax_academy_pro_meeting/delete_meeting', array( $self, 'delete_meeting' ) );
	}

	public function get_meeting_credentials() {
		check_ajax_referer( 'academy_nonce', 'security' );
		if ( ! current_user_can( 'manage_academy_instructor' ) ) {
			wp_die();
		}

		$user_id = get_current_user_id();
		$meet_credentials = get_user_meta( $user_id, 'academy_pro_google_calendar_access_token', true );
		$zoom_credentials = get_user_meta( $user_id, 'academy_pro_zoom_credentials', true );
		$response = [
			'google_meet' => $meet_credentials,
			'zoom' => json_decode( $zoom_credentials )
		];

		wp_send_json_success( $response );
	}

	public function render_meeting() {
		check_ajax_referer( 'academy_nonce', 'security' );
		$course_id = (int) isset( $_POST['course_id'] ) ? sanitize_text_field( wp_unslash( $_POST['course_id'] ) ) : '';
		$post_id   = (int) isset( $_POST['zoom_id'] ) ? sanitize_text_field( wp_unslash( $_POST['zoom_id'] ) ) : '';
		$user_id   = (int) get_current_user_id();

		$has_permission = \Academy\Helper::has_permission_to_access_curriculum( $course_id, $user_id, $post_id, 'meeting' );

		if ( $has_permission ) {
			do_action( 'academy_pro_meeting/frontend/before_render_meeting', $course_id, $post_id );
			$is_meeting = get_post( $post_id );
			if ( ! $is_meeting ) {
				wp_send_json_error( esc_html__( 'Sorry, something went wrong!', 'academy-pro' ) );
			}
			$meeting = json_decode( get_post_meta( $post_id, 'academy_meeting_response', true ), true );
			$meeting_author_id = (int) get_post_field( 'post_author', $post_id );
			$meeting['description'] = get_post_field( 'post_content', $post_id );
			$meeting['meeting_type'] = get_post_meta( $post_id, 'academy_meeting_type', true );
			$meeting['is_meeting_creator'] = get_current_user_id() === $meeting_author_id ? true : false;
			$meeting_date = isset( $meeting['meetingDate'] ) ? $meeting['meetingDate'] : $meeting['start_time'];
			$meeting['meeting_start_time'] = new \DateTime( $meeting_date, new \DateTimeZone( 'UTC' ) );
			wp_send_json_success( $meeting );
		}//end if
		wp_send_json_error( __( 'Access Denied', 'academy-pro' ) );
	}

	public function delete_meeting() {
		check_ajax_referer( 'academy_nonce', 'security' );
		if ( ! current_user_can( 'manage_academy_instructor' ) ) {
			wp_die();
		}

		$post_id = ( isset( $_POST['post_id'] ) ? sanitize_text_field( wp_unslash( $_POST['post_id'] ) ) : '' );
		$meeting_type = ( isset( $_POST['meeting_type'] ) ? sanitize_text_field( wp_unslash( $_POST['meeting_type'] ) ) : '' );
		$meeting_id = ( isset( $_POST['meeting_id'] ) ? sanitize_text_field( wp_unslash( $_POST['meeting_id'] ) ) : '' );

		if ( 'zoom' === $meeting_type ) {
			$zoom = new Zoom();
			$zoom->delete_zoom_meeting( $meeting_id, $post_id );
		}

		if ( 'google_meet' === $meeting_type ) {
			$googleMeet = new GoogleMeet();
			$googleMeet->delete_google_meet_meeting( $meeting_id, $post_id );
		}
	}
}
