<?php
namespace AcademyProNotifications\Admin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Settings {
	public static function get_saved_data() {
		$settings = get_option( ACADEMY_PRO_NOTIFICATIONS_SETTINGS_NAME );
		if ( $settings ) {
			return json_decode( $settings, true );
		}
		return [];
	}
	public static function get_default_data() {
		return apply_filters('academy_pro_notification/settings_default_data', [
			// New Instructor
			'is_enabled_new_instructor_registration_push'   => true,
			'is_enabled_new_instructor_registration_onsite' => true,
			// New Instructor approve
			'is_enabled_new_instructor_approve_push'        => true,
			'is_enabled_new_instructor_approve_onsite'      => true,
			// New Instructor Remove
			'is_enabled_new_instructor_remove_push'         => true,
			'is_enabled_new_instructor_remove_onsite'       => true,
			// Course Enrollment
			'is_enabled_new_course_enrollment_push'         => true,
			'is_enabled_new_course_enrollment_onsite'       => true,
			// Cancel Enrollment
			'is_enabled_cancel_enrollment_push'             => true,
			'is_enabled_cancel_enrollment_onsite'           => true,
			// Announcement
			'is_enabled_announcement_publish_push'          => true,
			'is_enabled_announcement_publish_onsite'        => true,
			// New Student
			'is_enabled_new_student_registration_push'      => true,
			'is_enabled_new_student_registration_onsite'    => true,
			// New Course Publish
			'is_enabled_new_course_publish_push'            => true,
			'is_enabled_new_course_publish_onsite'          => true,
			// Course Complete
			'is_enabled_course_complete_push'               => true,
			'is_enabled_course_complete_onsite'             => true,
			// New Course Review
			'is_enabled_course_review_push'                 => true,
			'is_enabled_course_review_onsite'               => true,
			// Quiz Evaluate
			'is_enabled_quiz_evaluate_push'                 => true,
			'is_enabled_quiz_evaluate_onsite'               => true,
			// Quiz Submit
			'is_enabled_quiz_submit_push'                   => true,
			'is_enabled_quiz_submit_onsite'                 => true,
			// Assignment Evaluate
			'is_enabled_assignment_evaluate_push'           => true,
			'is_enabled_assignment_evaluate_onsite'         => true,
			// Assignment Submit
			'is_enabled_assignment_submit_push'             => true,
			'is_enabled_assignment_submit_onsite'           => true,
			// Withdraw request approved
			'is_enabled_withdraw_request_approved_push'     => true,
			'is_enabled_withdraw_request_approved_onsite'   => true,
			// Withdraw request rejected
			'is_enabled_withdraw_request_rejected_push'     => false,
			'is_enabled_withdraw_request_rejected_onsite'   => false,
			// Question answer submit
			'is_enabled_question_answer_submit_push'        => false,
			'is_enabled_question_answer_submit_onsite'      => false,
			// Question answer reply
			'is_enabled_question_answer_reply_push'         => false,
			'is_enabled_question_answer_reply_onsite'       => false,
		]);
	}

	public static function save_settings( $form_data = false ) {
		$default_data = self::get_default_data();
		$saved_data = self::get_saved_data();
		$settings_data = wp_parse_args( $saved_data, $default_data );
		if ( $form_data ) {
			$settings_data = wp_parse_args( $form_data, $settings_data );
		}
		// if settings already saved, then update it
		if ( count( $saved_data ) ) {
			return update_option( ACADEMY_PRO_NOTIFICATIONS_SETTINGS_NAME, wp_json_encode( $settings_data ) );
		}
		return add_option( ACADEMY_PRO_NOTIFICATIONS_SETTINGS_NAME, wp_json_encode( $settings_data ) );
	}
}
