<?php
namespace AcademyProNotifications\Ajax;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Classes\AbstractAjaxHandler;
use  AcademyProNotifications\Admin\Settings as NotificationsSettings;
use Academy\Classes\Sanitizer;

class Settings extends AbstractAjaxHandler {
	protected $namespace = 'academy_pro_notifications';
	public function __construct() {
		$this->actions = array(
			'update_settings' => array(
				'callback' => array( $this, 'update_settings' ),
			),
		);
	}

	public function update_settings( $payload_data ) {
		$payload = Sanitizer::sanitize_payload([
			// New Instructor
			'is_enabled_new_instructor_registration_push'       => 'boolean',
			'is_enabled_new_instructor_registration_onsite'     => 'boolean',
			// New Instructor approve
			'is_enabled_new_instructor_approve_push'            => 'boolean',
			'is_enabled_new_instructor_approve_onsite'          => 'boolean',
			// New Instructor Remove
			'is_enabled_new_instructor_remove_push'             => 'boolean',
			'is_enabled_new_instructor_remove_onsite'           => 'boolean',
			// Course Enrollment
			'is_enabled_new_course_enrollment_push'             => 'boolean',
			'is_enabled_new_course_enrollment_onsite'           => 'boolean',
			// Cancel Enrollment
			'is_enabled_cancel_enrollment_push'                 => 'boolean',
			'is_enabled_cancel_enrollment_onsite'               => 'boolean',
			// Announcement
			'is_enabled_announcement_publish_push'              => 'boolean',
			'is_enabled_announcement_publish_onsite'            => 'boolean',
			// New Student
			'is_enabled_new_student_registration_push'          => 'boolean',
			'is_enabled_new_student_registration_onsite'        => 'boolean',
			// New Course Publish
			'is_enabled_new_course_publish_push'                => 'boolean',
			'is_enabled_new_course_publish_onsite'              => 'boolean',
			// Course Complete
			'is_enabled_course_complete_push'                   => 'boolean',
			'is_enabled_course_complete_onsite'                 => 'boolean',
			// New Course Review
			'is_enabled_course_review_push'                     => 'boolean',
			'is_enabled_course_review_onsite'                   => 'boolean',
			// Quiz Submit
			'is_enabled_quiz_submit_onsite'                     => 'boolean',
			'is_enabled_quiz_submit_push'                       => 'boolean',
			// Evaluate Quiz
			'is_enabled_quiz_evaluate_onsite'                   => 'boolean',
			'is_enabled_quiz_evaluate_push'                     => 'boolean',
			// Assignment Submit
			'is_enabled_assignment_submit_onsite'               => 'boolean',
			'is_enabled_assignment_submit_push'                 => 'boolean',
			// Evaluate Assignment
			'is_enabled_assignment_evaluate_onsite'             => 'boolean',
			'is_enabled_assignment_evaluate_push'               => 'boolean',
			// Withdraw request approved
			'is_enabled_withdraw_request_approved_push'         => 'boolean',
			'is_enabled_withdraw_request_approved_onsite'       => 'boolean',
			// Withdraw request reject
			'is_enabled_withdraw_request_rejected_push'         => 'boolean',
			'is_enabled_withdraw_request_rejected_onsite'       => 'boolean',
			// Question answer submit
			'is_enabled_question_answer_submit_push'            => 'boolean',
			'is_enabled_question_answer_submit_onsite'          => 'boolean',
			// Question answer reply
			'is_enabled_question_answer_reply_push'             => 'boolean',
			'is_enabled_question_answer_reply_onsite'           => 'boolean',
		], $payload_data );

		$default = NotificationsSettings::get_default_data();

		$is_update = NotificationsSettings::save_settings( [
			'is_enabled_new_instructor_registration_push'   => $payload['is_enabled_new_instructor_registration_push'] ?? $default['is_enabled_new_instructor_registration_push'],
			'is_enabled_new_instructor_registration_onsite' => $payload['is_enabled_new_instructor_registration_onsite'] ?? $default['is_enabled_new_instructor_registration_onsite'],
			'is_enabled_new_instructor_approve_push'        => $payload['is_enabled_new_instructor_approve_push'] ?? $default['is_enabled_new_instructor_approve_push'],
			'is_enabled_new_instructor_approve_onsite'      => $payload['is_enabled_new_instructor_approve_onsite'] ?? $default['is_enabled_new_instructor_approve_onsite'],
			'is_enabled_new_instructor_remove_push'         => $payload['is_enabled_new_instructor_remove_push'] ?? $default['is_enabled_new_instructor_remove_push'],
			'is_enabled_new_instructor_remove_onsite'       => $payload['is_enabled_new_instructor_remove_onsite'] ?? $default['is_enabled_new_instructor_remove_onsite'],
			'is_enabled_new_course_enrollment_push'         => $payload['is_enabled_new_course_enrollment_push'] ?? $default['is_enabled_new_course_enrollment_push'],
			'is_enabled_new_course_enrollment_onsite'       => $payload['is_enabled_new_course_enrollment_onsite'] ?? $default['is_enabled_new_course_enrollment_onsite'],
			'is_enabled_cancel_enrollment_push'             => $payload['is_enabled_cancel_enrollment_push'] ?? $default['is_enabled_cancel_enrollment_push'],
			'is_enabled_cancel_enrollment_onsite'           => $payload['is_enabled_cancel_enrollment_onsite'] ?? $default['is_enabled_cancel_enrollment_onsite'],
			'is_enabled_announcement_publish_push'          => $payload['is_enabled_announcement_publish_push'] ?? $default['is_enabled_announcement_publish_push'],
			'is_enabled_announcement_publish_onsite'        => $payload['is_enabled_announcement_publish_onsite'] ?? $default['is_enabled_announcement_publish_onsite'],
			'is_enabled_new_student_registration_push'      => $payload['is_enabled_new_student_registration_push'] ?? $default['is_enabled_new_student_registration_push'],
			'is_enabled_new_student_registration_onsite'    => $payload['is_enabled_new_student_registration_onsite'] ?? $default['is_enabled_new_student_registration_onsite'],
			'is_enabled_new_course_publish_push'            => $payload['is_enabled_new_course_publish_push'] ?? $default['is_enabled_new_course_publish_push'],
			'is_enabled_new_course_publish_onsite'          => $payload['is_enabled_new_course_publish_onsite'] ?? $default['is_enabled_new_course_publish_onsite'],
			'is_enabled_course_complete_push'               => $payload['is_enabled_course_complete_push'] ?? $default['is_enabled_course_complete_push'],
			'is_enabled_course_complete_onsite'             => $payload['is_enabled_course_complete_onsite'] ?? $default['is_enabled_course_complete_onsite'],
			'is_enabled_course_review_push'                 => $payload['is_enabled_course_review_push'] ?? $default['is_enabled_course_review_push'],
			'is_enabled_course_review_onsite'               => $payload['is_enabled_course_review_onsite'] ?? $default['is_enabled_course_review_onsite'],
			'is_enabled_quiz_submit_onsite'                 => $payload['is_enabled_quiz_submit_onsite'] ?? $default['is_enabled_quiz_submit_onsite'],
			'is_enabled_quiz_submit_push'                   => $payload['is_enabled_quiz_submit_push'] ?? $default['is_enabled_quiz_submit_push'],
			'is_enabled_quiz_evaluate_onsite'               => $payload['is_enabled_quiz_evaluate_onsite'] ?? $default['is_enabled_quiz_evaluate_onsite'],
			'is_enabled_quiz_evaluate_push'                 => $payload['is_enabled_quiz_evaluate_push'] ?? $default['is_enabled_quiz_evaluate_push'],
			'is_enabled_assignment_submit_onsite'           => $payload['is_enabled_assignment_submit_onsite'] ?? $default['is_enabled_assignment_submit_onsite'],
			'is_enabled_assignment_submit_push'             => $payload['is_enabled_assignment_submit_push'] ?? $default['is_enabled_assignment_submit_push'],
			'is_enabled_assignment_evaluate_onsite'         => $payload['is_enabled_assignment_evaluate_onsite'] ?? $default['is_enabled_assignment_evaluate_onsite'],
			'is_enabled_withdraw_request_approved_push'     => $payload['is_enabled_withdraw_request_approved_push'] ?? $default['is_enabled_withdraw_request_approved_push'],
			'is_enabled_withdraw_request_approved_onsite'   => $payload['is_enabled_withdraw_request_approved_onsite'] ?? $default['is_enabled_withdraw_request_approved_onsite'],
			'is_enabled_withdraw_request_rejected_push'     => $payload['is_enabled_withdraw_request_rejected_push'] ?? $default['is_enabled_withdraw_request_rejected_push'],
			'is_enabled_withdraw_request_rejected_onsite'   => $payload['is_enabled_withdraw_request_rejected_onsite'] ?? $default['is_enabled_withdraw_request_rejected_onsite'],
			'is_enabled_question_answer_submit_push'        => $payload['is_enabled_question_answer_submit_push'] ?? $default['is_enabled_question_answer_submit_push'],
			'is_enabled_question_answer_submit_onsite'      => $payload['is_enabled_question_answer_submit_onsite'] ?? $default['is_enabled_question_answer_submit_onsite'],
			'is_enabled_question_answer_reply_push'         => $payload['is_enabled_question_answer_reply_push'] ?? $default['is_enabled_question_answer_reply_push'],
			'is_enabled_question_answer_reply_onsite'       => $payload['is_enabled_question_answer_reply_onsite'] ?? $default['is_enabled_question_answer_reply_onsite'],
		]);
		do_action( 'academy_pro/admin/after_save_settings', $is_update, 'notification', $payload_data );
		wp_send_json_success( $is_update );
	}
}
