<?php
namespace AcademyProNotifications;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;
use AcademyProNotifications\Classes\Pusher;


final class Notifications implements AddonInterface {
	private $addon_name = 'notifications';

	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function define_constants() {
		/**
		 * Define constant for whole addon
		 */
		define( 'ACADEMY_PRO_NOTIFICATIONS_VERSION', 1.0 );
		define( 'ACADEMY_PRO_NOTIFICATIONS_VERSION_NAME', 'academy_pro_notification_version' );
		define( 'ACADEMY_PRO_NOTIFICATIONS_SETTINGS_NAME', 'academy_pro_notifications_settings' );
		define( 'ACADEMY_PRO_NOTIFICATIONS_PATH', ACADEMY_PRO_ROOT_DIR_PATH . 'addons/notifications' );
		define( 'ACADEMY_PRO_NOTIFICATIONS_ASSETS', ACADEMY_PRO_PLUGIN_ROOT_URI . 'addons/notifications/assets' );
	}

	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_$this->addon_name", array( $this, 'addon_activation_hook' ) );
		// if addon is not enabled then stop working
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		// Run addon functionality
		Ajax::init();
		Pusher::init();
		Hooks::init();
	}

	public function addon_activation_hook() {
		Installer::init();
		flush_rewrite_rules();
	}
}
