<?php
namespace AcademyProPaidMembershipsPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Frontend {
	public static function init() {
		$self = new self();
		// check engine
		if ( 'paid-memberships-pro' !== \Academy\Helper::get_settings( 'monetization_engine' ) ) {
			return;
		}
		add_filter( 'academy/templates/single_course/enroll_content', array( $self, 'pmpro_enroll_widget_content' ), 10, 2 );
		add_filter( 'academy/templates/single_course/enroll_form', array( $self, 'pmpro_pricing_widget' ), 10, 2 );
		add_filter( 'academy/course/get_course_type', array( $self, 'get_course_type' ), 10, 2 );
		add_filter( 'academy/templates/loop/price', array( $self, 'pmpro_price_tag' ), 10, 2 );
		add_filter( 'academy/before_enroll_course_type', [ $self, 'modify_course_type' ], 10, 2 );
		add_filter( 'rest_prepare_academy_courses', [ $self, 'add_course_price' ], 11, 2 );
	}
	public function pmpro_enroll_widget_content( $html, $course_id ) {
		$is_enrolled = \Academy\Helper::is_enrolled( $course_id, get_current_user_id() );
		if ( $is_enrolled ) {
			return $html;
		}

		$required_levels = Helper::has_course_access( $course_id );
		if ( is_array( $required_levels ) && count( $required_levels ) ) {
			return '';
		}
		return $html;
	}
	public function pmpro_pricing_widget( $html, $course_id ) {
		$is_enrolled = \Academy\Helper::is_enrolled( $course_id, get_current_user_id() );
		if ( $is_enrolled ) {
			return $html;
		}

		$required_levels = Helper::has_course_access( $course_id );
		if ( ! is_array( $required_levels ) || ! count( $required_levels ) ) {
			return $html;
		}

		$level_page_id = apply_filters( 'academy_pmpro_level_page_id', pmpro_getOption( 'levels_page_id' ) );
		$level_page_url = get_the_permalink( $level_page_id );

		ob_start();
		\AcademyPro\Helper::get_template('paid-memberships-pro/pricing.php', array(
			'required_levels' => $required_levels,
			'level_page_url'  => $level_page_url,
		) );
		return ob_get_clean();
	}
	public function get_course_type( $course_type, $course_id ) {
		$required_levels = Helper::has_course_access( $course_id );
		if ( ! is_array( $required_levels ) && true === $required_levels ) {
			return 'free';
		}
		return $course_type;
	}

	public function pmpro_price_tag( $course_price, $course_id ) {

		global $pmpro_currency;
		$current_currency = $pmpro_currency ? $pmpro_currency : '';
		$required_levels = Helper::has_course_access( $course_id );

		if ( is_array( $required_levels ) && ! empty( $required_levels ) ) {
			foreach ( $required_levels as $level ) {
				$price = number_format( $level->billing_amount, 2 );
				$cycle = $level->cycle_period;
				$output = $current_currency . ' ' . $price . '/' . $cycle;
				return $output;
			}
		}
		return $course_price;
	}

	public function add_course_price( $response, $post ) {
		global $pmpro_currency;

		$current_currency = $pmpro_currency ? $pmpro_currency : '';
		$required_levels = Helper::has_course_access( $post->ID );

		if ( is_array( $required_levels ) && ! empty( $required_levels ) ) {
			foreach ( $required_levels as $level ) {
				$price = number_format( $level->billing_amount, 2 );
				$response->data['academy_course_price'] = $current_currency . ' ' . $price;
			}
		}
		return $response;
	}

	public function modify_course_type( $course_type, $course_id ) {
		if ( 'paid' === $course_type && Helper::has_course_access( $course_id ) ) {
			return 'free';
		}
		return $course_type;
	}
}
