<?php
namespace AcademyProRestrictContentPro\Ajax;

use Academy\Classes\AbstractAjaxHandler;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Admin extends AbstractAjaxHandler {
	protected $namespace = 'academy_pro_restrict_content_pro';

	public function __construct() {
		$this->actions = array(
			'get_rcp_membership_levels' => array(
				'callback' => array( $this, 'get_rcp_membership_levels' ),
				'capability' => 'manage_academy_instructor',
			),
		);
	}

	public function get_rcp_membership_levels() {
		$levels = \rcp_get_membership_levels();

		$modified_levels = [];

		foreach ( $levels as $key => $level ) {
			$modified_levels[ $key ] = [
				'label' => $level->name,
				'value' => $level->id,
			];
		}

		wp_send_json_success( $modified_levels );
	}
}
