<?php
namespace AcademyProSendfox;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Academy\Interfaces\AddonInterface;

final class Sendfox implements AddonInterface {
	private $addon_name = 'sendfox';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {

	}
	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) || ! \Academy\Helper::is_plugin_active( 'wp-sendfox/wp-sendfox.php' ) ) {
			return;
		}
		// Run Addon functionality
		Integration::init();
		Settings::init();
	}

	public function load_dependency() {

	}

	public function addon_activation_hook() {

	}
}
