<?php
namespace AcademyProSocialLogin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Helper {


	public static function get_user_profile_info_facebook( $access_token, $facebook_app_id, $facebook_app_secret ) {

		$fb_url = 'https://graph.facebook.com/oauth/access_token';
		$fb_url = add_query_arg(
			array(
				'client_id'     => $facebook_app_id,
				'client_secret' => $facebook_app_secret,
				'grant_type'    => 'client_credentials',
			),
			$fb_url
		);

		$fb_response = wp_remote_get( $fb_url );

		if ( is_wp_error( $fb_response ) ) {
			return wp_send_json_error( $fb_response );
		}

		$fb_app_response = json_decode( wp_remote_retrieve_body( $fb_response ), true );

		$app_token = $fb_app_response['access_token'];

		$url = 'https://graph.facebook.com/debug_token';
		$url = add_query_arg(
			array(
				'input_token'  => $access_token,
				'access_token' => $app_token,
			),
			$url
		);

		$response = wp_remote_get( $url );

		if ( is_wp_error( $response ) ) {
			return wp_send_json_error( $response );
		}

		return json_decode( wp_remote_retrieve_body( $response ), true );
	}


	public static function get_user_email_facebook( $user_id, $access_token ) {

		$fb_email_url = 'https://graph.facebook.com/' . $user_id;
		$fb_email_url = add_query_arg(
			array(
				'fields'       => 'email',
				'access_token' => $access_token,
			),
			$fb_email_url
		);

		$email_response = wp_remote_get( $fb_email_url );

		if ( is_wp_error( $email_response ) ) {
			return wp_send_json_error( $email_response );
		}

		return json_decode( wp_remote_retrieve_body( $email_response ), true );

	}
}
