<?php

namespace AcademyProStoreEngine\hooks;

use Academy\Helper;
use StoreEngine\Classes\CartItem;
use StoreEngine\Classes\Order\OrderItemProduct;

class TutorBooking {

	public static function init() {
		$self = new self();
		add_filter( 'academy_pro/template/booking/loop_price_args', [ $self, 'update_price_args' ], 10, 2 );
		add_filter( 'academy_pro/single_booking/price_args', [ $self, 'update_price_args' ], 10, 2 );

		// cart
		add_filter( 'storeengine/cart/item_image_post_id', [ $self, 'replace_image_post_id' ], 10, 2 );
		add_filter( 'storeengine/cart/item_name', [ $self, 'update_cart_item_name' ], 10, 2 );
		add_filter( 'storeengine/cart/item_permalink', [ $self, 'update_cart_item_permalink' ], 10, 2 );

		// order
		add_action( 'storeengine/order/create_order_line_item', [ $self, 'save_booking_id_in_order_line_item' ], 10, 2 );
		add_filter( 'storeengine/order/item_image_post_id', [ $self, 'replace_order_item_image_post_id' ], 10, 2 );
		add_filter( 'storeengine/order/item_name', [ $self, 'replace_order_item_name' ], 10, 2 );
		add_filter( 'storeengine/order/item_permalink', [ $self, 'replace_order_item_permalink' ], 10, 2 );
	}

	public function update_price_args( array $args, int $booking_id ): array {
		$engine = Helper::monetization_engine();
		if ( 'storeengine' !== $engine ) {
			return $args;
		}

		$integration_repository = \StoreEngine\Utils\Helper::get_integration_repository_by_id( 'storeengine/tutor-booking', $booking_id );
		if ( empty( $integration_repository ) ) {
			return $args;
		}
		$integration_repository = current( $integration_repository );
		$args['price']          = '<span>' . $integration_repository->price->get_price_html() . '</span>';

		return $args;
	}

	public function replace_image_post_id( int $product_id, CartItem $cart_item ) {
		if ( ! is_array( $cart_item->item_data ) || ! isset( $cart_item->item_data['academy_pro_tutor_booking_id'] ) ) {
			return $product_id;
		}

		return $cart_item->item_data['academy_pro_tutor_booking_id'];
	}

	public function update_cart_item_name( string $name, CartItem $cart_item ): string {
		if ( ! is_array( $cart_item->item_data ) || ! isset( $cart_item->item_data['academy_pro_tutor_booking_id'] ) ) {
			return $name;
		}

		return get_the_title( $cart_item->item_data['academy_pro_tutor_booking_id'] );
	}

	public function update_cart_item_permalink( string $permalink, CartItem $cart_item ): string {
		if ( ! is_array( $cart_item->item_data ) || ! isset( $cart_item->item_data['academy_pro_tutor_booking_id'] ) ) {
			return $permalink;
		}

		return get_the_permalink( $cart_item->item_data['academy_pro_tutor_booking_id'] );
	}

	public function save_booking_id_in_order_line_item( OrderItemProduct $item, CartItem $cart_item ) {
		if ( ! is_array( $cart_item->item_data ) || ! isset( $cart_item->item_data['academy_pro_tutor_booking_id'] ) ) {
			return;
		}

		$item->add_meta_data( '_academy_pro_tutor_booking_id', $cart_item->item_data['academy_pro_tutor_booking_id'] );
	}

	public function replace_order_item_image_post_id( int $product_id, OrderItemProduct $order_item ): int {
		if ( ! $order_item->get_meta( '_academy_pro_tutor_booking_id' ) ) {
			return $product_id;
		}

		return (int) $order_item->get_meta( '_academy_pro_tutor_booking_id' );
	}

	public function replace_order_item_name( string $name, OrderItemProduct $order_item ): string {
		if ( ! $order_item->get_meta( '_academy_pro_tutor_booking_id' ) ) {
			return $name;
		}

		return get_the_title( (int) $order_item->get_meta( '_academy_pro_tutor_booking_id' ) );
	}

	public function replace_order_item_permalink( string $permalink, OrderItemProduct $order_item ) {
		if ( ! $order_item->get_meta( '_academy_pro_tutor_booking_id' ) ) {
			return $permalink;
		}

		return get_permalink( (int) $order_item->get_meta( '_academy_pro_tutor_booking_id' ) );
	}

}
