<?php

namespace AcademyProWishlistMember;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Academy\Interfaces\AddonInterface;

class WishlistMember implements AddonInterface {
	private $addon_name = 'wishlist-member';
	public function __construct() {
		$this->define_constants();
		$this->init_addon();
	}

	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}

	public function define_constants() {
		/*
		 * Define addon constants
		 */
		define( 'ACADEMY_PRO_ADDON_WISHLIST_MEMBER_VERSION', '1.0' );
		define( 'ACADEMY_PRO_ADDON_WISHLIST_MEMBER_PATH', ACADEMY_PRO_ADDONS_DIR_PATH . 'wishlist-member' );
	}

	public function init_addon() {
		// Fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// If addon is not active the return
		if ( ! \Academy\Helper::get_addon_active_status( $this->addon_name ) || ! Helper::is_wishlist_member_active() ) {
			return;
		}

		// Run addon functionality
		Hooks::init();
		new Init();
	}

	public function addon_activation_hook() {

	}
}
