<?php
namespace AcademyProWpml;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Academy\Interfaces\AddonInterface;
final class Wpml implements AddonInterface {
	private $addon_name = 'wpml';
	private function __construct() {
		$this->define_constants();
		$this->init_addon();
	}
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new self();
		}

		return $instance;
	}
	public function define_constants() {
		/**
		 * Defines CONSTANTS for Whole Addon.
		 */
		define( 'ACADEMY_PRO_WPML_VERSION', '1.0' );
		define( 'ACADEMY_PRO_WPML_VERSION_NAME', 'academy_pro_wpml_version' );
		define( 'ACADEMY_PRO_WPML_DIR_PATH', ACADEMY_PRO_ADDONS_DIR_PATH . 'wpml/' );
	}
	public function init_addon() {
		// fire addon activation hook
		add_action( "academy/addons/activated_{$this->addon_name}", array( $this, 'addon_activation_hook' ) );
		// if disable then stop running addon
		if ( ! \Academy\Helper::is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) || ! \Academy\Helper::get_addon_active_status( $this->addon_name ) ) {
			return;
		}

		if ( is_admin() ) {
			Classes\Settings::init();
		}

		Classes\LessonTranslation::init();
		Classes\KeepPluginPages::init();
	}
	public function addon_activation_hook() {

	}
}
